/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.metadata;

import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.apache.hadoop.hdds.StringUtils;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperationHandler;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBProfile;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfoList;
import org.apache.hadoop.ozone.container.common.interfaces.BlockIterator;
import org.apache.hadoop.ozone.container.common.utils.db.DatanodeDBProfile;
import org.apache.hadoop.ozone.container.metadata.AbstractDatanodeDBDefinition;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeTable;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDatanodeStore
implements DatanodeStore {
    private Table<String, Long> metadataTable;
    private Table<String, BlockData> blockDataTable;
    private Table<String, BlockData> blockDataTableWithIterator;
    private Table<String, ChunkInfoList> deletedBlocksTable;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDatanodeStore.class);
    private DBStore store;
    private final AbstractDatanodeDBDefinition dbDef;
    private final long containerID;
    private final ColumnFamilyOptions cfOptions;
    private static DatanodeDBProfile dbProfile;
    private final boolean openReadOnly;

    protected AbstractDatanodeStore(ConfigurationSource config, long containerID, AbstractDatanodeDBDefinition dbDef, boolean openReadOnly) throws IOException {
        dbProfile = DatanodeDBProfile.getProfile((DBProfile)config.getEnum("hdds.db.profile", (Enum)DBStoreBuilder.HDDS_DEFAULT_DB_PROFILE));
        this.cfOptions = dbProfile.getColumnFamilyOptions(config);
        this.dbDef = dbDef;
        this.containerID = containerID;
        this.openReadOnly = openReadOnly;
        this.start(config);
    }

    @Override
    public void start(ConfigurationSource config) throws IOException {
        if (this.store == null) {
            DBOptions options = dbProfile.getDBOptions();
            options.setCreateIfMissing(true);
            options.setCreateMissingColumnFamilies(true);
            String rocksDbStat = config.getTrimmed("ozone.metastore.rocksdb.statistics", "OFF");
            if (!rocksDbStat.equals("OFF")) {
                Statistics statistics = new Statistics();
                statistics.setStatsLevel(StatsLevel.valueOf((String)rocksDbStat));
                options.setStatistics(statistics);
            }
            this.store = DBStoreBuilder.newBuilder((ConfigurationSource)config, (DBDefinition)this.dbDef).setDBOptions(options).setDefaultCFOptions(this.cfOptions).setOpenReadOnly(this.openReadOnly).build();
            this.metadataTable = new DatanodeTable<String, Long>(this.dbDef.getMetadataColumnFamily().getTable(this.store));
            AbstractDatanodeStore.checkTableStatus(this.metadataTable, this.metadataTable.getName());
            this.blockDataTableWithIterator = this.dbDef.getBlockDataColumnFamily().getTable(this.store);
            this.blockDataTable = new DatanodeTable<String, BlockData>(this.blockDataTableWithIterator);
            AbstractDatanodeStore.checkTableStatus(this.blockDataTable, this.blockDataTable.getName());
            this.deletedBlocksTable = new DatanodeTable<String, ChunkInfoList>(this.dbDef.getDeletedBlocksColumnFamily().getTable(this.store));
            AbstractDatanodeStore.checkTableStatus(this.deletedBlocksTable, this.deletedBlocksTable.getName());
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @Override
    public DBStore getStore() {
        return this.store;
    }

    @Override
    public BatchOperationHandler getBatchHandler() {
        return this.store;
    }

    @Override
    public Table<String, Long> getMetadataTable() {
        return this.metadataTable;
    }

    @Override
    public Table<String, BlockData> getBlockDataTable() {
        return this.blockDataTable;
    }

    @Override
    public Table<String, ChunkInfoList> getDeletedBlocksTable() {
        return this.deletedBlocksTable;
    }

    @Override
    public BlockIterator<BlockData> getBlockIterator() {
        return new KeyValueBlockIterator(this.containerID, (TableIterator<String, ? extends Table.KeyValue<String, BlockData>>)this.blockDataTableWithIterator.iterator());
    }

    @Override
    public BlockIterator<BlockData> getBlockIterator(MetadataKeyFilters.KeyPrefixFilter filter) {
        return new KeyValueBlockIterator(this.containerID, (TableIterator<String, ? extends Table.KeyValue<String, BlockData>>)this.blockDataTableWithIterator.iterator(), filter);
    }

    @Override
    public void flushDB() throws IOException {
        this.store.flushDB();
    }

    @Override
    public void flushLog(boolean sync) throws IOException {
        this.store.flushLog(sync);
    }

    @Override
    public void compactDB() throws IOException {
        this.store.compactDB();
    }

    @VisibleForTesting
    public DatanodeDBProfile getDbProfile() {
        return dbProfile;
    }

    private static void checkTableStatus(Table<?, ?> table, String name) throws IOException {
        String logMessage = "Unable to get a reference to %s table. Cannot continue.";
        String errMsg = "Inconsistent DB state, Table - %s. Please check the logs for more info.";
        if (table == null) {
            LOG.error(String.format(logMessage, name));
            throw new IOException(String.format(errMsg, name));
        }
    }

    @InterfaceAudience.Public
    private static class KeyValueBlockIterator
    implements BlockIterator<BlockData>,
    Closeable {
        private static final Logger LOG = LoggerFactory.getLogger(KeyValueBlockIterator.class);
        private final TableIterator<String, ? extends Table.KeyValue<String, BlockData>> blockIterator;
        private static final MetadataKeyFilters.KeyPrefixFilter DEFAULT_BLOCK_FILTER = MetadataKeyFilters.getUnprefixedKeyFilter();
        private final MetadataKeyFilters.KeyPrefixFilter blockFilter;
        private BlockData nextBlock;
        private final long containerID;

        KeyValueBlockIterator(long containerID, TableIterator<String, ? extends Table.KeyValue<String, BlockData>> iterator) {
            this.containerID = containerID;
            this.blockIterator = iterator;
            this.blockFilter = DEFAULT_BLOCK_FILTER;
        }

        KeyValueBlockIterator(long containerID, TableIterator<String, ? extends Table.KeyValue<String, BlockData>> iterator, MetadataKeyFilters.KeyPrefixFilter filter) {
            this.containerID = containerID;
            this.blockIterator = iterator;
            this.blockFilter = filter;
        }

        @Override
        public BlockData nextBlock() throws IOException, NoSuchElementException {
            if (this.nextBlock != null) {
                BlockData currentBlock = this.nextBlock;
                this.nextBlock = null;
                return currentBlock;
            }
            if (this.hasNext()) {
                return this.nextBlock();
            }
            throw new NoSuchElementException("Block Iterator reached end for ContainerID " + this.containerID);
        }

        @Override
        public boolean hasNext() throws IOException {
            if (this.nextBlock != null) {
                return true;
            }
            while (this.blockIterator.hasNext()) {
                Table.KeyValue keyValue = (Table.KeyValue)this.blockIterator.next();
                byte[] keyBytes = StringUtils.string2Bytes((String)((String)keyValue.getKey()));
                if (!this.blockFilter.filterKey(null, keyBytes, null)) continue;
                this.nextBlock = (BlockData)keyValue.getValue();
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Block matching with filter found: blockID is : {} for containerID {}", (Object)this.nextBlock.getLocalID(), (Object)this.containerID);
                }
                return true;
            }
            return false;
        }

        @Override
        public void seekToFirst() {
            this.nextBlock = null;
            this.blockIterator.seekToFirst();
        }

        @Override
        public void seekToLast() {
            this.nextBlock = null;
            this.blockIterator.seekToLast();
        }

        @Override
        public void close() throws IOException {
            this.blockIterator.close();
        }
    }
}

