/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.statemachine.background;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.scm.pipeline.PipelineID;
import org.apache.hadoop.hdds.utils.BackgroundService;
import org.apache.hadoop.hdds.utils.BackgroundTask;
import org.apache.hadoop.hdds.utils.BackgroundTaskQueue;
import org.apache.hadoop.hdds.utils.BackgroundTaskResult;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.TopNOrderedContainerDeletionChoosingPolicy;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDeletionChoosingPolicy;
import org.apache.hadoop.ozone.container.common.interfaces.Handler;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeConfiguration;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.XceiverServerRatis;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaTwoImpl;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.util.Time;
import org.apache.ratis.thirdparty.com.google.protobuf.InvalidProtocolBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockDeletingService
extends BackgroundService {
    private static final Logger LOG = LoggerFactory.getLogger(BlockDeletingService.class);
    private OzoneContainer ozoneContainer;
    private ContainerDeletionChoosingPolicy containerDeletionPolicy;
    private final ConfigurationSource conf;
    private final int blockLimitPerInterval;
    private static final int TASK_PRIORITY_DEFAULT = 1;
    private static final int BLOCK_DELETING_SERVICE_CORE_POOL_SIZE = 10;

    public BlockDeletingService(OzoneContainer ozoneContainer, long serviceInterval, long serviceTimeout, TimeUnit timeUnit, ConfigurationSource conf) {
        super("BlockDeletingService", serviceInterval, timeUnit, 10, serviceTimeout);
        this.ozoneContainer = ozoneContainer;
        try {
            this.containerDeletionPolicy = (ContainerDeletionChoosingPolicy)conf.getClass("ozone.scm.keyvalue.container.deletion-choosing.policy", TopNOrderedContainerDeletionChoosingPolicy.class, ContainerDeletionChoosingPolicy.class).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.conf = conf;
        DatanodeConfiguration dnConf = (DatanodeConfiguration)conf.getObject(DatanodeConfiguration.class);
        this.blockLimitPerInterval = dnConf.getBlockDeletionLimit();
    }

    public BackgroundTaskQueue getTasks() {
        BackgroundTaskQueue queue;
        block5: {
            queue = new BackgroundTaskQueue();
            List<Object> containers = Lists.newArrayList();
            try {
                containers = this.chooseContainerForBlockDeletion(this.blockLimitPerInterval, this.containerDeletionPolicy);
                BlockDeletingTask containerBlockInfos = null;
                long totalBlocks = 0L;
                for (ContainerBlockInfo containerBlockInfo : containers) {
                    containerBlockInfos = new BlockDeletingTask(containerBlockInfo.containerData, 1, containerBlockInfo.numBlocksToDelete);
                    queue.add((BackgroundTask)containerBlockInfos);
                    totalBlocks += containerBlockInfo.numBlocksToDelete.longValue();
                }
                if (containers.size() > 0) {
                    LOG.info("Plan to choose {} blocks for block deletion, actually deleting {} blocks.", (Object)this.blockLimitPerInterval, (Object)totalBlocks);
                }
            }
            catch (StorageContainerException e) {
                LOG.warn("Failed to initiate block deleting tasks, caused by unable to get containers info. Retry in next interval. ", (Throwable)e);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug("Unexpected error occurs during deleting blocks.", (Throwable)e);
            }
        }
        return queue;
    }

    public List<ContainerBlockInfo> chooseContainerForBlockDeletion(int blockLimit, ContainerDeletionChoosingPolicy deletionPolicy) throws StorageContainerException {
        Map<Long, ContainerData> containerDataMap = this.ozoneContainer.getContainerSet().getContainerMap().entrySet().stream().filter(e -> this.isDeletionAllowed((ContainerData)((Container)e.getValue()).getContainerData(), deletionPolicy)).collect(Collectors.toMap(Map.Entry::getKey, e -> ((Container)e.getValue()).getContainerData()));
        return deletionPolicy.chooseContainerForBlockDeletion(blockLimit, containerDataMap);
    }

    private boolean isDeletionAllowed(ContainerData containerData, ContainerDeletionChoosingPolicy deletionPolicy) {
        if (!deletionPolicy.isValidContainerType(containerData.getContainerType())) {
            return false;
        }
        if (!containerData.isClosed()) {
            return false;
        }
        if (this.ozoneContainer.getWriteChannel() instanceof XceiverServerRatis) {
            PipelineID pipelineID;
            XceiverServerRatis ratisServer = (XceiverServerRatis)this.ozoneContainer.getWriteChannel();
            if (!ratisServer.isExist((pipelineID = PipelineID.valueOf((UUID)UUID.fromString(containerData.getOriginPipelineId()))).getProtobuf())) {
                return true;
            }
            try {
                long minReplicatedIndex = ratisServer.getMinReplicatedIndex(pipelineID);
                long containerBCSID = containerData.getBlockCommitSequenceId();
                if (minReplicatedIndex >= 0L && minReplicatedIndex < containerBCSID) {
                    LOG.warn("Close Container log Index {} is not replicated across all the servers in the pipeline {} as the min replicated index is {}. Deletion is not allowed in this container yet.", new Object[]{containerBCSID, containerData.getOriginPipelineId(), minReplicatedIndex});
                    return false;
                }
                return true;
            }
            catch (IOException ioe) {
                if (!ratisServer.isExist(pipelineID.getProtobuf())) {
                    return true;
                }
                LOG.info(ioe.getMessage());
                return false;
            }
        }
        return true;
    }

    private class BlockDeletingTask
    implements BackgroundTask {
        private final int priority;
        private final KeyValueContainerData containerData;
        private final long blocksToDelete;

        BlockDeletingTask(ContainerData containerName, int priority, long blocksToDelete) {
            this.priority = priority;
            this.containerData = (KeyValueContainerData)containerName;
            this.blocksToDelete = blocksToDelete;
        }

        /*
         * Loose catch block
         */
        public BackgroundTaskResult call() throws Exception {
            Container<?> container = BlockDeletingService.this.ozoneContainer.getContainerSet().getContainer(this.containerData.getContainerID());
            container.writeLock();
            File dataDir = new File(this.containerData.getChunksPath());
            long startTime = Time.monotonicNow();
            try {
                try (ReferenceCountedDB meta = BlockUtils.getDB(this.containerData, BlockDeletingService.this.conf);){
                    ContainerBackgroundTaskResult crr;
                    if (this.containerData.getSchemaVersion().equals("1")) {
                        crr = this.deleteViaSchema1(meta, container, dataDir, startTime);
                    } else if (this.containerData.getSchemaVersion().equals("2")) {
                        crr = this.deleteViaSchema2(meta, container, dataDir, startTime);
                    } else {
                        throw new UnsupportedOperationException("Only schema version 1 and schema version 2 are supported.");
                    }
                    ContainerBackgroundTaskResult containerBackgroundTaskResult = crr;
                    return containerBackgroundTaskResult;
                }
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                container.writeUnlock();
            }
        }

        public boolean checkDataDir(File dataDir) {
            boolean b = true;
            if (!dataDir.exists() || !dataDir.isDirectory()) {
                LOG.error("Invalid container data dir {} : does not exist or not a directory", (Object)dataDir.getAbsolutePath());
                b = false;
            }
            return b;
        }

        public ContainerBackgroundTaskResult deleteViaSchema1(ReferenceCountedDB meta, Container container, File dataDir, long startTime) throws IOException {
            ContainerBackgroundTaskResult crr = new ContainerBackgroundTaskResult();
            if (!this.checkDataDir(dataDir)) {
                return crr;
            }
            try {
                Table<String, BlockData> blockDataTable = meta.getStore().getBlockDataTable();
                MetadataKeyFilters.KeyPrefixFilter filter = MetadataKeyFilters.getDeletingKeyFilter();
                List toDeleteBlocks = blockDataTable.getSequentialRangeKVs(null, (int)this.blocksToDelete, new MetadataKeyFilters.MetadataKeyFilter[]{filter});
                if (toDeleteBlocks.isEmpty()) {
                    LOG.debug("No under deletion block found in container : {}", (Object)this.containerData.getContainerID());
                }
                LinkedList<String> succeedBlocks = new LinkedList<String>();
                LOG.debug("Container : {}, To-Delete blocks : {}", (Object)this.containerData.getContainerID(), (Object)toDeleteBlocks.size());
                Handler handler = Objects.requireNonNull(BlockDeletingService.this.ozoneContainer.getDispatcher().getHandler(container.getContainerType()));
                for (Table.KeyValue entry : toDeleteBlocks) {
                    String blockName = (String)entry.getKey();
                    LOG.debug("Deleting block {}", (Object)blockName);
                    if (entry.getValue() == null) {
                        LOG.warn("Missing delete block(Container = " + ((ContainerData)container.getContainerData()).getContainerID() + ", Block = " + (String)blockName);
                        continue;
                    }
                    try {
                        handler.deleteBlock(container, (BlockData)entry.getValue());
                        succeedBlocks.add(blockName);
                    }
                    catch (InvalidProtocolBufferException e) {
                        LOG.error("Failed to parse block info for block {}", (Object)blockName, (Object)e);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to delete files for block {}", (Object)blockName, (Object)e);
                    }
                }
                try (BatchOperation batch = meta.getStore().getBatchHandler().initBatchOperation();){
                    for (String entry : succeedBlocks) {
                        blockDataTable.deleteWithBatch(batch, (Object)entry);
                    }
                    int deleteBlockCount = succeedBlocks.size();
                    this.containerData.updateAndCommitDBCounters(meta, batch, deleteBlockCount);
                    this.containerData.decrPendingDeletionBlocks(deleteBlockCount);
                    this.containerData.decrKeyCount(deleteBlockCount);
                }
                if (!succeedBlocks.isEmpty()) {
                    LOG.info("Container: {}, deleted blocks: {}, task elapsed time: {}ms", new Object[]{this.containerData.getContainerID(), succeedBlocks.size(), Time.monotonicNow() - startTime});
                }
                crr.addAll(succeedBlocks);
                return crr;
            }
            catch (IOException exception) {
                LOG.warn("Deletion operation was not successful for container: " + ((ContainerData)container.getContainerData()).getContainerID(), (Throwable)exception);
                throw exception;
            }
        }

        public ContainerBackgroundTaskResult deleteViaSchema2(ReferenceCountedDB meta, Container container, File dataDir, long startTime) throws IOException {
            ContainerBackgroundTaskResult crr = new ContainerBackgroundTaskResult();
            if (!this.checkDataDir(dataDir)) {
                return crr;
            }
            try {
                Table<String, BlockData> blockDataTable = meta.getStore().getBlockDataTable();
                DatanodeStore ds = meta.getStore();
                DatanodeStoreSchemaTwoImpl dnStoreTwoImpl = (DatanodeStoreSchemaTwoImpl)ds;
                Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> deleteTxns = dnStoreTwoImpl.getDeleteTransactionTable();
                ArrayList<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> delBlocks = new ArrayList<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction>();
                int totalBlocks = 0;
                int numBlocks = 0;
                try (TableIterator iter = dnStoreTwoImpl.getDeleteTransactionTable().iterator();){
                    while (iter.hasNext() && (long)numBlocks < this.blocksToDelete) {
                        StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTx = (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)((Table.KeyValue)iter.next()).getValue();
                        numBlocks += delTx.getLocalIDList().size();
                        delBlocks.add(delTx);
                    }
                }
                if (delBlocks.isEmpty()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No transaction found in container : {}", (Object)this.containerData.getContainerID());
                    }
                    return crr;
                }
                LOG.debug("Container : {}, To-Delete blocks : {}", (Object)this.containerData.getContainerID(), (Object)delBlocks.size());
                Handler handler = Objects.requireNonNull(BlockDeletingService.this.ozoneContainer.getDispatcher().getHandler(container.getContainerType()));
                totalBlocks = this.deleteTransactions(delBlocks, handler, blockDataTable, container);
                try (BatchOperation batch = meta.getStore().getBatchHandler().initBatchOperation();){
                    for (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTx : delBlocks) {
                        deleteTxns.deleteWithBatch(batch, (Object)delTx.getTxID());
                        for (Long blk : delTx.getLocalIDList()) {
                            String bID = blk.toString();
                            meta.getStore().getBlockDataTable().deleteWithBatch(batch, (Object)bID);
                        }
                    }
                    meta.getStore().getBatchHandler().commitBatchOperation(batch);
                    this.containerData.updateAndCommitDBCounters(meta, batch, totalBlocks);
                    this.containerData.decrPendingDeletionBlocks(totalBlocks);
                    this.containerData.decrKeyCount(totalBlocks);
                }
                LOG.info("Container: {}, deleted blocks: {}, task elapsed time: {}ms", new Object[]{this.containerData.getContainerID(), totalBlocks, Time.monotonicNow() - startTime});
                return crr;
            }
            catch (IOException exception) {
                LOG.warn("Deletion operation was not successful for container: " + ((ContainerData)container.getContainerData()).getContainerID(), (Throwable)exception);
                throw exception;
            }
        }

        private int deleteTransactions(List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> delBlocks, Handler handler, Table<String, BlockData> blockDataTable, Container container) throws IOException {
            int blocksDeleted = 0;
            for (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction entry : delBlocks) {
                for (Long blkLong : entry.getLocalIDList()) {
                    String blk = blkLong.toString();
                    BlockData blkInfo = (BlockData)blockDataTable.get((Object)blk);
                    LOG.debug("Deleting block {}", (Object)blk);
                    if (blkInfo == null) {
                        LOG.warn("Missing delete block(Container = " + ((ContainerData)container.getContainerData()).getContainerID() + ", Block = " + blk);
                        continue;
                    }
                    try {
                        handler.deleteBlock(container, blkInfo);
                        ++blocksDeleted;
                    }
                    catch (InvalidProtocolBufferException e) {
                        LOG.error("Failed to parse block info for block {}", (Object)blk, (Object)e);
                    }
                    catch (IOException e) {
                        LOG.error("Failed to delete files for block {}", (Object)blk, (Object)e);
                    }
                }
            }
            return blocksDeleted;
        }

        public int getPriority() {
            return this.priority;
        }
    }

    private static class ContainerBackgroundTaskResult
    implements BackgroundTaskResult {
        private List<String> deletedBlockIds = new LinkedList<String>();

        ContainerBackgroundTaskResult() {
        }

        public void addBlockId(String blockId) {
            this.deletedBlockIds.add(blockId);
        }

        public void addAll(List<String> blockIds) {
            this.deletedBlockIds.addAll(blockIds);
        }

        public List<String> getDeletedBlocks() {
            return this.deletedBlockIds;
        }

        public int getSize() {
            return this.deletedBlockIds.size();
        }
    }

    public static class ContainerBlockInfo {
        private final ContainerData containerData;
        private final Long numBlocksToDelete;

        public ContainerBlockInfo(ContainerData containerData, Long blocks) {
            this.containerData = containerData;
            this.numBlocksToDelete = blocks;
        }

        public ContainerData getContainerData() {
            return this.containerData;
        }

        public Long getBlocks() {
            return this.numBlocksToDelete;
        }
    }
}

