/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.interfaces;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.common.ChecksumData;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainer;

public interface ChunkManager {
    public void writeChunk(Container var1, BlockID var2, ChunkInfo var3, ChunkBuffer var4, DispatcherContext var5) throws StorageContainerException;

    default public void writeChunk(Container container, BlockID blockID, ChunkInfo info, ByteBuffer data, DispatcherContext dispatcherContext) throws StorageContainerException {
        ChunkBuffer wrapper = ChunkBuffer.wrap((ByteBuffer)data);
        this.writeChunk(container, blockID, info, wrapper, dispatcherContext);
    }

    public ChunkBuffer readChunk(Container var1, BlockID var2, ChunkInfo var3, DispatcherContext var4) throws StorageContainerException;

    public void deleteChunk(Container var1, BlockID var2, ChunkInfo var3) throws StorageContainerException;

    public void deleteChunks(Container var1, BlockData var2) throws StorageContainerException;

    default public void shutdown() {
    }

    default public void finishWriteChunks(KeyValueContainer kvContainer, BlockData blockData) throws IOException {
    }

    public static long getBufferCapacityForChunkRead(ChunkInfo chunkInfo, long defaultReadBufferCapacity) {
        long bufferCapacity = 0L;
        if (chunkInfo.isReadDataIntoSingleBuffer()) {
            bufferCapacity = chunkInfo.getLen();
        } else {
            ChecksumData checksumData = chunkInfo.getChecksumData();
            if (checksumData != null) {
                bufferCapacity = checksumData.getChecksumType() == ContainerProtos.ChecksumType.NONE ? defaultReadBufferCapacity : (long)checksumData.getBytesPerChecksum();
            }
        }
        if (bufferCapacity == 0L) {
            bufferCapacity = chunkInfo.getLen();
        }
        return bufferCapacity;
    }
}

