/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.impl;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.common.ChunkBuffer;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.transport.server.ratis.DispatcherContext;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.common.volume.VolumeIOStats;
import org.apache.hadoop.ozone.container.keyvalue.helpers.ChunkUtils;
import org.apache.hadoop.ozone.container.keyvalue.interfaces.ChunkManager;

public class ChunkManagerDummyImpl
implements ChunkManager {
    @Override
    public void writeChunk(Container container, BlockID blockID, ChunkInfo info, ChunkBuffer data, DispatcherContext dispatcherContext) throws StorageContainerException {
        Preconditions.checkNotNull((Object)dispatcherContext);
        DispatcherContext.WriteChunkStage stage = dispatcherContext.getStage();
        Object containerData = container.getContainerData();
        if (stage == DispatcherContext.WriteChunkStage.WRITE_DATA || stage == DispatcherContext.WriteChunkStage.COMBINED) {
            ChunkUtils.validateBufferSize(info.getLen(), data.remaining());
            HddsVolume volume = ((ContainerData)containerData).getVolume();
            VolumeIOStats volumeIOStats = volume.getVolumeIOStats();
            volumeIOStats.incWriteOpCount();
            volumeIOStats.incWriteBytes(info.getLen());
        }
        if (stage == DispatcherContext.WriteChunkStage.COMMIT_DATA || stage == DispatcherContext.WriteChunkStage.COMBINED) {
            ((ContainerData)containerData).updateWriteStats(info.getLen(), false);
        }
    }

    @Override
    public ChunkBuffer readChunk(Container container, BlockID blockID, ChunkInfo info, DispatcherContext dispatcherContext) throws StorageContainerException {
        ChunkUtils.limitReadSize(info.getLen());
        return ChunkBuffer.wrap((ByteBuffer)ByteBuffer.allocate((int)info.getLen()));
    }

    @Override
    public void deleteChunk(Container container, BlockID blockID, ChunkInfo info) {
    }

    @Override
    public void deleteChunks(Container container, BlockData blockData) throws StorageContainerException {
    }
}

