/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.keyvalue.helpers;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.utils.MetadataKeyFilters;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.helpers.ContainerUtils;
import org.apache.hadoop.ozone.container.common.interfaces.BlockIterator;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.keyvalue.helpers.KeyValueContainerLocationUtil;
import org.apache.hadoop.ozone.container.metadata.AbstractDatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaOneImpl;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaTwoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyValueContainerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueContainerUtil.class);

    private KeyValueContainerUtil() {
    }

    public static void createContainerMetaData(long containerID, File containerMetaDataPath, File chunksPath, File dbFile, String schemaVersion, ConfigurationSource conf) throws IOException {
        AbstractDatanodeStore store;
        Preconditions.checkNotNull((Object)containerMetaDataPath);
        Preconditions.checkNotNull((Object)conf);
        if (!containerMetaDataPath.mkdirs()) {
            LOG.error("Unable to create directory for metadata storage. Path: {}", (Object)containerMetaDataPath);
            throw new IOException("Unable to create directory for metadata storage. Path: " + containerMetaDataPath);
        }
        if (!chunksPath.mkdirs()) {
            LOG.error("Unable to create chunks directory Container {}", (Object)chunksPath);
            FileUtils.deleteDirectory((File)containerMetaDataPath);
            FileUtils.deleteDirectory((File)containerMetaDataPath.getParentFile());
            throw new IOException("Unable to create directory for data storage. Path: " + chunksPath);
        }
        if (schemaVersion.equals("1")) {
            store = new DatanodeStoreSchemaOneImpl(conf, containerID, dbFile.getAbsolutePath(), false);
        } else if (schemaVersion.equals("2")) {
            store = new DatanodeStoreSchemaTwoImpl(conf, containerID, dbFile.getAbsolutePath(), false);
        } else {
            throw new IllegalArgumentException("Unrecognized schema version for container: " + schemaVersion);
        }
        ReferenceCountedDB db = new ReferenceCountedDB(store, dbFile.getAbsolutePath());
        BlockUtils.addDB(db, dbFile.getAbsolutePath(), conf);
    }

    public static void removeContainer(KeyValueContainerData containerData, ConfigurationSource conf) throws IOException {
        Preconditions.checkNotNull((Object)containerData);
        File containerMetaDataPath = new File(containerData.getMetadataPath());
        File chunksPath = new File(containerData.getChunksPath());
        BlockUtils.removeDB(containerData, conf);
        FileUtils.deleteDirectory((File)containerMetaDataPath);
        FileUtils.deleteDirectory((File)chunksPath);
        FileUtils.deleteDirectory((File)containerMetaDataPath.getParentFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parseKVContainerData(KeyValueContainerData kvContainerData, ConfigurationSource config) throws IOException {
        long containerID = kvContainerData.getContainerID();
        File metadataPath = new File(kvContainerData.getMetadataPath());
        ContainerUtils.verifyChecksum(kvContainerData, config);
        File dbFile = KeyValueContainerLocationUtil.getContainerDBFile(metadataPath, containerID);
        if (!dbFile.exists()) {
            LOG.error("Container DB file is missing for ContainerID {}. Skipping loading of this container.", (Object)containerID);
            return;
        }
        kvContainerData.setDbFile(dbFile);
        if (kvContainerData.getSchemaVersion() == null) {
            kvContainerData.setSchemaVersion("1");
        }
        boolean isBlockMetadataSet = false;
        ReferenceCountedDB cachedDB = null;
        DatanodeStore store = null;
        try {
            Long blockCount;
            Long bytesUsed;
            Long bcsId;
            try {
                store = BlockUtils.getUncachedDatanodeStore(kvContainerData, config, true);
            }
            catch (IOException e) {
                cachedDB = BlockUtils.getDB(kvContainerData, config);
                store = cachedDB.getStore();
                LOG.warn("Attempt to get an uncached RocksDB handle failed and an instance was retrieved from the cache. This should only happen in tests");
            }
            Table<String, Long> metadataTable = store.getMetadataTable();
            Long pendingDeleteBlockCount = (Long)metadataTable.get((Object)"#PENDINGDELETEBLOCKCOUNT");
            if (pendingDeleteBlockCount != null) {
                kvContainerData.incrPendingDeletionBlocks(pendingDeleteBlockCount);
            } else {
                MetadataKeyFilters.KeyPrefixFilter filter = MetadataKeyFilters.getDeletingKeyFilter();
                int numPendingDeletionBlocks = store.getBlockDataTable().getSequentialRangeKVs(null, Integer.MAX_VALUE, new MetadataKeyFilters.MetadataKeyFilter[]{filter}).size();
                kvContainerData.incrPendingDeletionBlocks(numPendingDeletionBlocks);
            }
            Long delTxnId = (Long)metadataTable.get((Object)"#delTX");
            if (delTxnId != null) {
                kvContainerData.updateDeleteTransactionId(delTxnId);
            }
            if ((bcsId = (Long)metadataTable.get((Object)"#BCSID")) != null) {
                kvContainerData.updateBlockCommitSequenceId(bcsId);
            }
            if ((bytesUsed = (Long)metadataTable.get((Object)"#BYTESUSED")) != null) {
                isBlockMetadataSet = true;
                kvContainerData.setBytesUsed(bytesUsed);
            }
            if ((blockCount = (Long)metadataTable.get((Object)"#BLOCKCOUNT")) != null) {
                isBlockMetadataSet = true;
                kvContainerData.setKeyCount(blockCount);
            }
            if (!isBlockMetadataSet) {
                KeyValueContainerUtil.initializeUsedBytesAndBlockCount(store, kvContainerData);
            }
        }
        finally {
            if (cachedDB != null) {
                cachedDB.close();
            } else if (store != null) {
                try {
                    store.stop();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException("Unexpected exception closing the RocksDB when loading containers", e);
                }
            }
        }
    }

    private static void initializeUsedBytesAndBlockCount(DatanodeStore store, KeyValueContainerData kvData) throws IOException {
        String errorMessage = "Failed to parse block data for Container " + kvData.getContainerID();
        long blockCount = 0L;
        long usedBytes = 0L;
        try (BlockIterator<BlockData> blockIter = store.getBlockIterator(MetadataKeyFilters.getUnprefixedKeyFilter());){
            while (blockIter.hasNext()) {
                ++blockCount;
                try {
                    usedBytes += KeyValueContainerUtil.getBlockLength(blockIter.nextBlock());
                }
                catch (IOException ex) {
                    LOG.error(errorMessage);
                }
            }
        }
        blockIter = store.getBlockIterator(MetadataKeyFilters.getDeletingKeyFilter());
        var8_6 = null;
        try {
            while (blockIter.hasNext()) {
                ++blockCount;
                try {
                    usedBytes += KeyValueContainerUtil.getBlockLength(blockIter.nextBlock());
                }
                catch (IOException ex) {
                    LOG.error(errorMessage);
                }
            }
        }
        catch (Throwable throwable) {
            var8_6 = throwable;
            throw throwable;
        }
        finally {
            if (blockIter != null) {
                if (var8_6 != null) {
                    try {
                        blockIter.close();
                    }
                    catch (Throwable throwable) {
                        var8_6.addSuppressed(throwable);
                    }
                } else {
                    blockIter.close();
                }
            }
        }
        kvData.setBytesUsed(usedBytes);
        kvData.setKeyCount(blockCount);
    }

    private static long getBlockLength(BlockData block) throws IOException {
        long blockLen = 0L;
        List chunkInfoList = block.getChunks();
        for (ContainerProtos.ChunkInfo chunk : chunkInfoList) {
            ChunkInfo info = ChunkInfo.getFromProtoBuf((ContainerProtos.ChunkInfo)chunk);
            blockLen += info.getLen();
        }
        return blockLen;
    }

    public static Path getDataDirectory(KeyValueContainerData kvContainerData) {
        String chunksPath = kvContainerData.getChunksPath();
        Preconditions.checkNotNull((Object)chunksPath);
        return Paths.get(chunksPath, new String[0]);
    }

    public static Path getMetadataDirectory(KeyValueContainerData kvContainerData) {
        String metadataPath = kvContainerData.getMetadataPath();
        Preconditions.checkNotNull((Object)metadataPath);
        return Paths.get(metadataPath, new String[0]);
    }
}

