/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import org.apache.hadoop.hdds.fs.CachingSpaceUsageSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckParams;
import org.apache.hadoop.hdds.fs.SpaceUsageSource;

public class VolumeUsage
implements SpaceUsageSource {
    private final CachingSpaceUsageSource source;
    private boolean shutdownComplete;
    private final long reservedInBytes;

    VolumeUsage(SpaceUsageCheckParams checkParams, long reservedInBytes) {
        this.reservedInBytes = reservedInBytes;
        this.source = new CachingSpaceUsageSource(checkParams);
        this.start();
    }

    public long getCapacity() {
        return Math.max(this.source.getCapacity(), 0L);
    }

    public long getAvailable() {
        return this.source.getAvailable() - this.getRemainingReserved();
    }

    public long getUsedSpace() {
        return this.source.getUsedSpace();
    }

    private long getOtherUsed() {
        long totalUsed = this.source.getCapacity() - this.source.getAvailable();
        return Math.max(totalUsed - this.source.getUsedSpace(), 0L);
    }

    private long getRemainingReserved() {
        return Math.max(this.reservedInBytes - this.getOtherUsed(), 0L);
    }

    public synchronized void start() {
        this.source.start();
    }

    public synchronized void shutdown() {
        if (!this.shutdownComplete) {
            this.source.shutdown();
            this.shutdownComplete = true;
        }
    }
}

