/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.volume;

import java.io.File;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.fs.SpaceUsageCheckFactory;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.checker.Checkable;
import org.apache.hadoop.hdfs.server.datanode.checker.VolumeCheckResult;
import org.apache.hadoop.ozone.container.common.volume.VolumeInfo;
import org.apache.hadoop.ozone.container.common.volume.VolumeSet;
import org.apache.hadoop.util.DiskChecker;

public abstract class StorageVolume
implements Checkable<Boolean, VolumeCheckResult> {
    private final File storageDir;
    private final VolumeInfo volumeInfo;
    private final VolumeSet volumeSet;

    protected StorageVolume(Builder<?> b) throws IOException {
        if (!((Builder)b).failedVolume) {
            StorageLocation location = StorageLocation.parse((String)((Builder)b).volumeRootStr);
            this.storageDir = new File(location.getUri().getPath(), ((Builder)b).storageDirStr);
            this.volumeInfo = new VolumeInfo.Builder(((Builder)b).volumeRootStr, ((Builder)b).conf).storageType(((Builder)b).storageType).usageCheckFactory(((Builder)b).usageCheckFactory).build();
            this.volumeSet = ((Builder)b).volumeSet;
        } else {
            this.storageDir = new File(((Builder)b).volumeRootStr);
            this.volumeInfo = null;
            this.volumeSet = null;
        }
    }

    public long getCapacity() {
        return this.volumeInfo != null ? this.volumeInfo.getCapacity() : 0L;
    }

    public long getAvailable() {
        return this.volumeInfo != null ? this.volumeInfo.getAvailable() : 0L;
    }

    public long getUsedSpace() {
        return this.volumeInfo != null ? this.volumeInfo.getScmUsed() : 0L;
    }

    public File getStorageDir() {
        return this.storageDir;
    }

    public VolumeInfo getVolumeInfo() {
        return this.volumeInfo;
    }

    public VolumeSet getVolumeSet() {
        return this.volumeSet;
    }

    public StorageType getStorageType() {
        if (this.volumeInfo != null) {
            return this.volumeInfo.getStorageType();
        }
        return StorageType.DEFAULT;
    }

    public String getStorageID() {
        return "";
    }

    public void failVolume() {
        if (this.volumeInfo != null) {
            this.volumeInfo.shutdownUsageThread();
        }
    }

    public void shutdown() {
        if (this.volumeInfo != null) {
            this.volumeInfo.shutdownUsageThread();
        }
    }

    public VolumeCheckResult check(@Nullable Boolean unused) throws Exception {
        if (!this.storageDir.exists()) {
            return VolumeCheckResult.FAILED;
        }
        DiskChecker.checkDir((File)this.storageDir);
        return VolumeCheckResult.HEALTHY;
    }

    public int hashCode() {
        return Objects.hash(this.storageDir);
    }

    public boolean equals(Object other) {
        return this == other || other instanceof StorageVolume && ((StorageVolume)other).storageDir.equals(this.storageDir);
    }

    public String toString() {
        return this.getStorageDir().toString();
    }

    public static abstract class Builder<T extends Builder<T>> {
        private final String volumeRootStr;
        private String storageDirStr;
        private ConfigurationSource conf;
        private StorageType storageType;
        private SpaceUsageCheckFactory usageCheckFactory;
        private VolumeSet volumeSet;
        private boolean failedVolume = false;

        public Builder(String volumeRootStr, String storageDirStr) {
            this.volumeRootStr = volumeRootStr;
            this.storageDirStr = storageDirStr;
        }

        public abstract T getThis();

        public T conf(ConfigurationSource config) {
            this.conf = config;
            return this.getThis();
        }

        public T storageType(StorageType st) {
            this.storageType = st;
            return this.getThis();
        }

        public T usageCheckFactory(SpaceUsageCheckFactory factory) {
            this.usageCheckFactory = factory;
            return this.getThis();
        }

        public T volumeSet(VolumeSet volSet) {
            this.volumeSet = volSet;
            return this.getThis();
        }

        public T failedVolume(boolean failed) {
            this.failedVolume = failed;
            return this.getThis();
        }

        public abstract StorageVolume build() throws IOException;

        public String getVolumeRootStr() {
            return this.volumeRootStr;
        }

        public boolean getFailedVolume() {
            return this.failedVolume;
        }

        public StorageType getStorageType() {
            return this.storageType;
        }
    }

    public static enum VolumeType {
        DATA_VOLUME,
        META_VOLUME;

    }
}

