/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils.db;

import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.StorageUnit;
import org.apache.hadoop.hdds.utils.db.DBProfile;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.Cache;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.LRUCache;
import org.rocksdb.TableFormatConfig;

public abstract class DatanodeDBProfile {
    public abstract DBOptions getDBOptions();

    public abstract ColumnFamilyOptions getColumnFamilyOptions(ConfigurationSource var1);

    public static DatanodeDBProfile getProfile(DBProfile dbProfile) {
        switch (dbProfile) {
            case SSD: {
                return new SSD();
            }
            case DISK: {
                return new Disk();
            }
        }
        throw new IllegalArgumentException("DatanodeDBProfile does not exist for " + dbProfile);
    }

    private static final class StorageBasedProfile {
        private final AtomicReference<ColumnFamilyOptions> cfOptions = new AtomicReference();
        private final DBProfile baseProfile;

        private StorageBasedProfile(DBProfile profile) {
            this.baseProfile = profile;
        }

        private DBOptions getDBOptions() {
            return this.baseProfile.getDBOptions();
        }

        private ColumnFamilyOptions getColumnFamilyOptions(ConfigurationSource config) {
            this.cfOptions.updateAndGet(op -> op != null ? op : this.baseProfile.getColumnFamilyOptions().setTableFormatConfig((TableFormatConfig)this.getBlockBasedTableConfig(config)));
            return this.cfOptions.get();
        }

        private BlockBasedTableConfig getBlockBasedTableConfig(ConfigurationSource config) {
            BlockBasedTableConfig blockBasedTableConfig = this.baseProfile.getBlockBasedTableConfig();
            if (config == null) {
                return blockBasedTableConfig;
            }
            long cacheSize = (long)config.getStorageSize("hdds.datanode.metadata.rocksdb.cache.size", "1GB", StorageUnit.BYTES);
            blockBasedTableConfig.setBlockCache((Cache)new LRUCache(cacheSize));
            return blockBasedTableConfig;
        }
    }

    public static class Disk
    extends DatanodeDBProfile {
        private static final StorageBasedProfile DISK_STORAGE_BASED_PROFILE = new StorageBasedProfile(DBProfile.DISK);

        @Override
        public DBOptions getDBOptions() {
            return Disk.DISK_STORAGE_BASED_PROFILE.getDBOptions();
        }

        @Override
        public ColumnFamilyOptions getColumnFamilyOptions(ConfigurationSource config) {
            return Disk.DISK_STORAGE_BASED_PROFILE.getColumnFamilyOptions(config);
        }
    }

    public static class SSD
    extends DatanodeDBProfile {
        private static final StorageBasedProfile SSD_STORAGE_BASED_PROFILE = new StorageBasedProfile(DBProfile.SSD);

        @Override
        public DBOptions getDBOptions() {
            return SSD.SSD_STORAGE_BASED_PROFILE.getDBOptions();
        }

        @Override
        public ColumnFamilyOptions getColumnFamilyOptions(ConfigurationSource config) {
            return SSD.SSD_STORAGE_BASED_PROFILE.getColumnFamilyOptions(config);
        }
    }
}

