/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.ozone.common.InconsistentStorageStateException;
import org.apache.hadoop.ozone.container.common.HDDSVolumeLayoutVersion;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.apache.hadoop.ozone.container.upgrade.VersionedDatanodeFeatures;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;

public final class HddsVolumeUtil {
    private static final String VERSION_FILE = "VERSION";
    private static final String STORAGE_ID_PREFIX = "DS-";

    private HddsVolumeUtil() {
    }

    public static File getVersionFile(File rootDir) {
        return new File(rootDir, VERSION_FILE);
    }

    public static String generateUuid() {
        return STORAGE_ID_PREFIX + UUID.randomUUID();
    }

    public static String getHddsRoot(String volumeRoot) {
        if (volumeRoot.endsWith("hdds")) {
            return volumeRoot;
        }
        File hddsRoot = new File(volumeRoot, "hdds");
        return hddsRoot.getPath();
    }

    @VisibleForTesting
    public static String getStorageID(Properties props, File versionFile) throws InconsistentStorageStateException {
        return HddsVolumeUtil.getProperty(props, "storageID", versionFile);
    }

    @VisibleForTesting
    public static String getClusterID(Properties props, File versionFile, String clusterID) throws InconsistentStorageStateException {
        String cid = HddsVolumeUtil.getProperty(props, "clusterID", versionFile);
        if (clusterID == null) {
            return cid;
        }
        if (!clusterID.equals(cid)) {
            throw new InconsistentStorageStateException("Mismatched ClusterIDs. Version File : " + versionFile + " has clusterID: " + cid + " and Datanode has clusterID: " + clusterID);
        }
        return cid;
    }

    @VisibleForTesting
    public static String getDatanodeUUID(Properties props, File versionFile, String datanodeUuid) throws InconsistentStorageStateException {
        String datanodeID = HddsVolumeUtil.getProperty(props, "datanodeUuid", versionFile);
        if (datanodeUuid != null && !datanodeUuid.equals(datanodeID)) {
            throw new InconsistentStorageStateException("Mismatched DatanodeUUIDs. Version File : " + versionFile + " has datanodeUuid: " + datanodeID + " and Datanode has datanodeUuid: " + datanodeUuid);
        }
        return datanodeID;
    }

    @VisibleForTesting
    public static long getCreationTime(Properties props, File versionFile) throws InconsistentStorageStateException {
        long currentTime;
        String cTimeStr = HddsVolumeUtil.getProperty(props, "ctime", versionFile);
        long cTime = Long.parseLong(cTimeStr);
        if (cTime > (currentTime = Time.now()) || cTime < 0L) {
            throw new InconsistentStorageStateException("Invalid Creation time in Version File : " + versionFile + " - " + cTime + ". Current system time is " + currentTime);
        }
        return cTime;
    }

    @VisibleForTesting
    public static int getLayOutVersion(Properties props, File versionFile) throws InconsistentStorageStateException {
        String lvStr = HddsVolumeUtil.getProperty(props, "layOutVersion", versionFile);
        int lv = Integer.parseInt(lvStr);
        if (HDDSVolumeLayoutVersion.getLatestVersion().getVersion() != lv) {
            throw new InconsistentStorageStateException("Invalid layOutVersion. Version file has layOutVersion as " + lv + " and latest Datanode layOutVersion is " + HDDSVolumeLayoutVersion.getLatestVersion().getVersion());
        }
        return lv;
    }

    public static String getProperty(Properties props, String propName, File versionFile) throws InconsistentStorageStateException {
        String value = props.getProperty(propName);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw new InconsistentStorageStateException("Invalid " + propName + ". Version File : " + versionFile + " has null or empty " + propName);
        }
        return value;
    }

    public static boolean checkVolume(HddsVolume hddsVolume, String scmId, String clusterId, ConfigurationSource conf, Logger logger) {
        File hddsRoot = hddsVolume.getHddsRootDir();
        String volumeRoot = hddsRoot.getPath();
        File clusterDir = new File(hddsRoot, clusterId);
        try {
            hddsVolume.format(clusterId);
        }
        catch (IOException ex) {
            logger.error("Error during formatting volume {}.", (Object)volumeRoot, (Object)ex);
            return false;
        }
        File[] hddsFiles = hddsRoot.listFiles();
        if (hddsFiles == null) {
            return false;
        }
        if (hddsFiles.length == 1) {
            String id = VersionedDatanodeFeatures.ScmHA.chooseContainerPathID(conf, scmId, clusterId);
            File idDir = new File(hddsRoot, id);
            if (!idDir.mkdir()) {
                logger.error("Unable to create ID directory {} for datanode.", (Object)idDir);
                return false;
            }
            return true;
        }
        if (hddsFiles.length == 2) {
            return VersionedDatanodeFeatures.ScmHA.upgradeVolumeIfNeeded(hddsVolume, clusterId);
        }
        if (!clusterDir.exists()) {
            logger.error("Volume {} is in an inconsistent state. {} files found but cluster ID directory {} does not exist.", new Object[]{volumeRoot, hddsFiles.length, clusterDir});
            return false;
        }
        return true;
    }
}

