/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.states.endpoint;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import java.io.IOException;
import java.time.ZonedDateTime;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.upgrade.HDDSLayoutVersionManager;
import org.apache.hadoop.ozone.container.common.helpers.DeletedContainerBlocksSummary;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.upgrade.UpgradeUtils;
import org.apache.hadoop.ozone.protocol.commands.CloseContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.ClosePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.CreatePipelineCommand;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlocksCommand;
import org.apache.hadoop.ozone.protocol.commands.DeleteContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.FinalizeNewLayoutVersionCommand;
import org.apache.hadoop.ozone.protocol.commands.ReplicateContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SetNodeOperationalStateCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatEndpointTask
implements Callable<EndpointStateMachine.EndPointStates> {
    static final Logger LOG = LoggerFactory.getLogger(HeartbeatEndpointTask.class);
    private final EndpointStateMachine rpcEndpoint;
    private final ConfigurationSource conf;
    private HddsProtos.DatanodeDetailsProto datanodeDetailsProto;
    private StateContext context;
    private int maxContainerActionsPerHB;
    private int maxPipelineActionsPerHB;
    private HDDSLayoutVersionManager layoutVersionManager;

    public HeartbeatEndpointTask(EndpointStateMachine rpcEndpoint, ConfigurationSource conf, StateContext context) {
        this(rpcEndpoint, conf, context, context.getParent().getLayoutVersionManager());
    }

    public HeartbeatEndpointTask(EndpointStateMachine rpcEndpoint, ConfigurationSource conf, StateContext context, HDDSLayoutVersionManager versionManager) {
        this.rpcEndpoint = rpcEndpoint;
        this.conf = conf;
        this.context = context;
        this.maxContainerActionsPerHB = conf.getInt("hdds.container.action.max.limit", 20);
        this.maxPipelineActionsPerHB = conf.getInt("hdds.pipeline.action.max.limit", 20);
        this.layoutVersionManager = versionManager != null ? versionManager : context.getParent().getLayoutVersionManager();
    }

    public HddsProtos.DatanodeDetailsProto getDatanodeDetailsProto() {
        return this.datanodeDetailsProto;
    }

    public void setDatanodeDetailsProto(HddsProtos.DatanodeDetailsProto datanodeDetailsProto) {
        this.datanodeDetailsProto = datanodeDetailsProto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EndpointStateMachine.EndPointStates call() throws Exception {
        this.rpcEndpoint.lock();
        StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder = null;
        try {
            Preconditions.checkState((this.datanodeDetailsProto != null ? 1 : 0) != 0);
            StorageContainerDatanodeProtocolProtos.LayoutVersionProto layoutinfo = UpgradeUtils.toLayoutVersionProto(this.layoutVersionManager.getMetadataLayoutVersion(), this.layoutVersionManager.getSoftwareLayoutVersion());
            requestBuilder = StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.newBuilder().setDatanodeDetails(this.datanodeDetailsProto).setDataNodeLayoutVersion(layoutinfo);
            this.addReports(requestBuilder);
            this.addContainerActions(requestBuilder);
            this.addPipelineActions(requestBuilder);
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto request = requestBuilder.build();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sending heartbeat message :: {}", (Object)request.toString());
            }
            StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto response = this.rpcEndpoint.getEndPoint().sendHeartbeat(request);
            this.processResponse(response, this.datanodeDetailsProto);
            this.rpcEndpoint.setLastSuccessfulHeartbeat(ZonedDateTime.now());
            this.rpcEndpoint.zeroMissedCount();
        }
        catch (IOException ex) {
            Preconditions.checkState((requestBuilder != null ? 1 : 0) != 0);
            this.putBackIncrementalReports(requestBuilder);
            this.rpcEndpoint.logIfNeeded(ex);
        }
        finally {
            this.rpcEndpoint.unlock();
        }
        return this.rpcEndpoint.getState();
    }

    private void putBackIncrementalReports(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        LinkedList<GeneratedMessage> reports = new LinkedList<GeneratedMessage>();
        if (requestBuilder.getCommandStatusReportsCount() != 0) {
            reports.addAll(requestBuilder.getCommandStatusReportsList());
        }
        if (requestBuilder.getIncrementalContainerReportCount() != 0) {
            reports.addAll(requestBuilder.getIncrementalContainerReportList());
        }
        this.context.putBackReports(reports, this.rpcEndpoint.getAddress());
    }

    private void addReports(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        block0: for (GeneratedMessage report : this.context.getAllAvailableReports(this.rpcEndpoint.getAddress())) {
            String reportName = report.getDescriptorForType().getFullName();
            for (Descriptors.FieldDescriptor descriptor : StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.getDescriptor().getFields()) {
                String heartbeatFieldName = descriptor.getMessageType().getFullName();
                if (!heartbeatFieldName.equals(reportName)) continue;
                if (descriptor.isRepeated()) {
                    requestBuilder.addRepeatedField(descriptor, (Object)report);
                    continue block0;
                }
                requestBuilder.setField(descriptor, (Object)report);
                continue block0;
            }
        }
    }

    private void addContainerActions(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        List<StorageContainerDatanodeProtocolProtos.ContainerAction> actions = this.context.getPendingContainerAction(this.rpcEndpoint.getAddress(), this.maxContainerActionsPerHB);
        if (!actions.isEmpty()) {
            StorageContainerDatanodeProtocolProtos.ContainerActionsProto cap = StorageContainerDatanodeProtocolProtos.ContainerActionsProto.newBuilder().addAllContainerActions(actions).build();
            requestBuilder.setContainerActions(cap);
        }
    }

    private void addPipelineActions(StorageContainerDatanodeProtocolProtos.SCMHeartbeatRequestProto.Builder requestBuilder) {
        List<StorageContainerDatanodeProtocolProtos.PipelineAction> actions = this.context.getPendingPipelineAction(this.rpcEndpoint.getAddress(), this.maxPipelineActionsPerHB);
        if (!actions.isEmpty()) {
            StorageContainerDatanodeProtocolProtos.PipelineActionsProto pap = StorageContainerDatanodeProtocolProtos.PipelineActionsProto.newBuilder().addAllPipelineActions(actions).build();
            requestBuilder.setPipelineActions(pap);
        }
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    private void processResponse(StorageContainerDatanodeProtocolProtos.SCMHeartbeatResponseProto response, HddsProtos.DatanodeDetailsProto datanodeDetails) {
        Preconditions.checkState((boolean)response.getDatanodeUUID().equalsIgnoreCase(datanodeDetails.getUuid()), (Object)"Unexpected datanode ID in the response.");
        block11: for (StorageContainerDatanodeProtocolProtos.SCMCommandProto commandResponseProto : response.getCommandsList()) {
            switch (commandResponseProto.getCommandType()) {
                case reregisterCommand: {
                    if (this.rpcEndpoint.getState() == EndpointStateMachine.EndPointStates.HEARTBEAT) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Received SCM notification to register. Interrupt HEARTBEAT and transit to REGISTER state.");
                        }
                        this.rpcEndpoint.setState(EndpointStateMachine.EndPointStates.REGISTER);
                        continue block11;
                    }
                    if (!LOG.isDebugEnabled()) continue block11;
                    LOG.debug("Illegal state {} found, expecting {}.", (Object)this.rpcEndpoint.getState().name(), (Object)EndpointStateMachine.EndPointStates.HEARTBEAT);
                    continue block11;
                }
                case deleteBlocksCommand: {
                    DeleteBlocksCommand db = DeleteBlocksCommand.getFromProtobuf(commandResponseProto.getDeleteBlocksCommandProto());
                    if (commandResponseProto.hasTerm()) {
                        db.setTerm(commandResponseProto.getTerm());
                    }
                    if (db.blocksTobeDeleted().isEmpty()) continue block11;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(DeletedContainerBlocksSummary.getFrom(db.blocksTobeDeleted()).toString());
                    }
                    this.context.addCommand(db);
                    continue block11;
                }
                case closeContainerCommand: {
                    CloseContainerCommand closeContainer = CloseContainerCommand.getFromProtobuf(commandResponseProto.getCloseContainerCommandProto());
                    if (commandResponseProto.hasTerm()) {
                        closeContainer.setTerm(commandResponseProto.getTerm());
                    }
                    if (commandResponseProto.hasEncodedToken()) {
                        closeContainer.setEncodedToken(commandResponseProto.getEncodedToken());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM container close request for container {}", (Object)closeContainer.getContainerID());
                    }
                    this.context.addCommand(closeContainer);
                    continue block11;
                }
                case replicateContainerCommand: {
                    ReplicateContainerCommand replicateContainerCommand = ReplicateContainerCommand.getFromProtobuf(commandResponseProto.getReplicateContainerCommandProto());
                    if (commandResponseProto.hasTerm()) {
                        replicateContainerCommand.setTerm(commandResponseProto.getTerm());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM container replicate request for container {}", (Object)replicateContainerCommand.getContainerID());
                    }
                    this.context.addCommand(replicateContainerCommand);
                    continue block11;
                }
                case deleteContainerCommand: {
                    DeleteContainerCommand deleteContainerCommand = DeleteContainerCommand.getFromProtobuf(commandResponseProto.getDeleteContainerCommandProto());
                    if (commandResponseProto.hasTerm()) {
                        deleteContainerCommand.setTerm(commandResponseProto.getTerm());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM delete container request for container {}", (Object)deleteContainerCommand.getContainerID());
                    }
                    this.context.addCommand(deleteContainerCommand);
                    continue block11;
                }
                case createPipelineCommand: {
                    CreatePipelineCommand createPipelineCommand = CreatePipelineCommand.getFromProtobuf(commandResponseProto.getCreatePipelineCommandProto());
                    if (commandResponseProto.hasTerm()) {
                        createPipelineCommand.setTerm(commandResponseProto.getTerm());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM create pipeline request {}", (Object)createPipelineCommand.getPipelineID());
                    }
                    this.context.addCommand(createPipelineCommand);
                    continue block11;
                }
                case closePipelineCommand: {
                    ClosePipelineCommand closePipelineCommand = ClosePipelineCommand.getFromProtobuf(commandResponseProto.getClosePipelineCommandProto());
                    if (commandResponseProto.hasTerm()) {
                        closePipelineCommand.setTerm(commandResponseProto.getTerm());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM close pipeline request {}", (Object)closePipelineCommand.getPipelineID());
                    }
                    this.context.addCommand(closePipelineCommand);
                    continue block11;
                }
                case setNodeOperationalStateCommand: {
                    SetNodeOperationalStateCommand setNodeOperationalStateCommand = SetNodeOperationalStateCommand.getFromProtobuf(commandResponseProto.getSetNodeOperationalStateCommandProto());
                    if (commandResponseProto.hasTerm()) {
                        setNodeOperationalStateCommand.setTerm(commandResponseProto.getTerm());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM set operational state command. State: {} Expiry: {}", (Object)setNodeOperationalStateCommand.getOpState(), (Object)setNodeOperationalStateCommand.getStateExpiryEpochSeconds());
                    }
                    this.context.addCommand(setNodeOperationalStateCommand);
                    continue block11;
                }
                case finalizeNewLayoutVersionCommand: {
                    FinalizeNewLayoutVersionCommand finalizeNewLayoutVersionCommand = FinalizeNewLayoutVersionCommand.getFromProtobuf(commandResponseProto.getFinalizeNewLayoutVersionCommandProto());
                    if (commandResponseProto.hasTerm()) {
                        finalizeNewLayoutVersionCommand.setTerm(commandResponseProto.getTerm());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Received SCM finalize command {}", (Object)finalizeNewLayoutVersionCommand.getId());
                    }
                    this.context.addCommand(finalizeNewLayoutVersionCommand);
                    continue block11;
                }
            }
            throw new IllegalArgumentException("Unknown response : " + commandResponseProto.getCommandType().name());
        }
    }

    public static class Builder {
        private EndpointStateMachine endPointStateMachine;
        private ConfigurationSource conf;
        private DatanodeDetails datanodeDetails;
        private StateContext context;
        private HDDSLayoutVersionManager versionManager;

        public Builder setEndpointStateMachine(EndpointStateMachine rpcEndPoint) {
            this.endPointStateMachine = rpcEndPoint;
            return this;
        }

        public Builder setLayoutVersionManager(HDDSLayoutVersionManager lvm) {
            this.versionManager = lvm;
            return this;
        }

        public Builder setConfig(ConfigurationSource config) {
            this.conf = config;
            return this;
        }

        public Builder setDatanodeDetails(DatanodeDetails dnDetails) {
            this.datanodeDetails = dnDetails;
            return this;
        }

        public Builder setContext(StateContext stateContext) {
            this.context = stateContext;
            return this;
        }

        public HeartbeatEndpointTask build() {
            if (this.endPointStateMachine == null) {
                LOG.error("No endpoint specified.");
                throw new IllegalArgumentException("A valid endpoint state machine is needed to construct HeartbeatEndpointTask task");
            }
            if (this.conf == null) {
                LOG.error("No config specified.");
                throw new IllegalArgumentException("A valid configration is needed to construct HeartbeatEndpointTask task");
            }
            if (this.datanodeDetails == null) {
                LOG.error("No datanode specified.");
                throw new IllegalArgumentException("A valid Node ID is needed to construct HeartbeatEndpointTask task");
            }
            HeartbeatEndpointTask task = new HeartbeatEndpointTask(this.endPointStateMachine, this.conf, this.context, this.versionManager);
            task.setDatanodeDetailsProto(this.datanodeDetails.getProtoBufMessage());
            return task;
        }
    }
}

