/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.statemachine.DatanodeStateMachine;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.FinalizeNewLayoutVersionCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.ozone.upgrade.UpgradeFinalizer;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FinalizeNewLayoutVersionCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FinalizeNewLayoutVersionCommandHandler.class);
    private AtomicLong invocationCount = new AtomicLong(0L);
    private long totalTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SCMCommand command, OzoneContainer ozoneContainer, StateContext context, SCMConnectionManager connectionManager) {
        LOG.info("Processing FinalizeNewLayoutVersionCommandHandler command.");
        this.invocationCount.incrementAndGet();
        long startTime = Time.monotonicNow();
        DatanodeStateMachine dsm = context.getParent();
        StorageContainerDatanodeProtocolProtos.FinalizeNewLayoutVersionCommandProto finalizeCommand = ((FinalizeNewLayoutVersionCommand)command).getProto();
        try {
            if (finalizeCommand.getFinalizeNewLayoutVersion() && dsm.getLayoutVersionManager().getUpgradeState() == UpgradeFinalizer.Status.FINALIZATION_REQUIRED) {
                LOG.info("Finalize Upgrade called!");
                dsm.finalizeUpgrade();
            }
        }
        catch (Exception e) {
            LOG.debug("Unexpected Error: {} ", (Throwable)e);
        }
        finally {
            long endTime = Time.monotonicNow();
            this.totalTime += endTime - startTime;
        }
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.finalizeNewLayoutVersionCommand;
    }

    @Override
    public int getInvocationCount() {
        return (int)this.invocationCount.get();
    }

    @Override
    public long getAverageRunTime() {
        if (this.invocationCount.get() > 0L) {
            return this.totalTime / this.invocationCount.get();
        }
        return 0L;
    }
}

