/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.hdds.utils.db.BatchOperation;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.ozone.container.common.helpers.BlockData;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfoList;
import org.apache.hadoop.ozone.container.common.helpers.DeletedContainerBlocksSummary;
import org.apache.hadoop.ozone.container.common.impl.ContainerSet;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.common.utils.ReferenceCountedDB;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.helpers.BlockUtils;
import org.apache.hadoop.ozone.container.metadata.DatanodeStore;
import org.apache.hadoop.ozone.container.metadata.DatanodeStoreSchemaTwoImpl;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.CommandStatus;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlockCommandStatus;
import org.apache.hadoop.ozone.protocol.commands.DeleteBlocksCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteBlocksCommandHandler
implements CommandHandler {
    public static final Logger LOG = LoggerFactory.getLogger(DeleteBlocksCommandHandler.class);
    private final ContainerSet containerSet;
    private final ConfigurationSource conf;
    private int invocationCount;
    private long totalTime;
    private boolean cmdExecuted;

    public DeleteBlocksCommandHandler(ContainerSet cset, ConfigurationSource conf) {
        this.containerSet = cset;
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(SCMCommand command, OzoneContainer container, StateContext context, SCMConnectionManager connectionManager) {
        StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto deleteAck;
        StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto blockDeletionACK;
        long startTime;
        block5: {
            this.cmdExecuted = false;
            startTime = Time.monotonicNow();
            blockDeletionACK = null;
            if (command.getType() == StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand) break block5;
            LOG.warn("Skipping handling command, expected command type {} but found {}", (Object)StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand, (Object)command.getType());
            StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto deleteAck2 = blockDeletionACK;
            Consumer<CommandStatus> statusUpdater = cmdStatus -> {
                cmdStatus.setStatus(this.cmdExecuted);
                ((DeleteBlockCommandStatus)cmdStatus).setBlocksDeletionAck(deleteAck2);
            };
            this.updateCommandStatus(context, command, statusUpdater, LOG);
            long endTime = Time.monotonicNow();
            this.totalTime += endTime - startTime;
            ++this.invocationCount;
            return;
        }
        try {
            LOG.debug("Processing block deletion command.");
            DeleteBlocksCommand cmd = (DeleteBlocksCommand)command;
            List<StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> containerBlocks = cmd.blocksTobeDeleted();
            DeletedContainerBlocksSummary summary = DeletedContainerBlocksSummary.getFrom(containerBlocks);
            LOG.info("Start to delete container blocks, TXIDs={}, numOfContainers={}, numOfBlocks={}", new Object[]{summary.getTxIDSummary(), summary.getNumOfContainers(), summary.getNumOfBlocks()});
            StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.Builder resultBuilder = StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.newBuilder();
            containerBlocks.forEach(entry -> {
                StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult.Builder txResultBuilder = StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult.newBuilder();
                txResultBuilder.setTxID(entry.getTxID());
                long containerId = entry.getContainerID();
                int newDeletionBlocks = 0;
                try {
                    Container<?> cont = this.containerSet.getContainer(containerId);
                    if (cont == null) {
                        throw new StorageContainerException("Unable to find the container " + containerId, ContainerProtos.Result.CONTAINER_NOT_FOUND);
                    }
                    ContainerProtos.ContainerType containerType = cont.getContainerType();
                    switch (containerType) {
                        case KeyValueContainer: {
                            KeyValueContainerData containerData = (KeyValueContainerData)cont.getContainerData();
                            cont.writeLock();
                            try {
                                if (containerData.getSchemaVersion().equals("1")) {
                                    this.markBlocksForDeletionSchemaV1(containerData, (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)entry);
                                } else {
                                    if (!containerData.getSchemaVersion().equals("2")) throw new UnsupportedOperationException("Only schema version 1 and schema version 2 are supported.");
                                    this.markBlocksForDeletionSchemaV2(containerData, (StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction)entry, newDeletionBlocks, entry.getTxID());
                                }
                            }
                            finally {
                                cont.writeUnlock();
                            }
                            txResultBuilder.setContainerID(containerId).setSuccess(true);
                            break;
                        }
                        default: {
                            LOG.error("Delete Blocks Command Handler is not implemented for containerType {}", (Object)containerType);
                            break;
                        }
                    }
                }
                catch (IOException e) {
                    LOG.warn("Failed to delete blocks for container={}, TXID={}", new Object[]{entry.getContainerID(), entry.getTxID(), e});
                    txResultBuilder.setContainerID(containerId).setSuccess(false);
                }
                resultBuilder.addResults(txResultBuilder.build()).setDnId(context.getParent().getDatanodeDetails().getUuid().toString());
            });
            blockDeletionACK = resultBuilder.build();
            if (!containerBlocks.isEmpty() && LOG.isDebugEnabled()) {
                LOG.debug("Sending following block deletion ACK to SCM");
                for (StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto.DeleteBlockTransactionResult result : blockDeletionACK.getResultsList()) {
                    LOG.debug("{} : {}", (Object)result.getTxID(), (Object)result.getSuccess());
                }
            }
            this.cmdExecuted = true;
            deleteAck = blockDeletionACK;
        }
        catch (Throwable throwable) {
            StorageContainerDatanodeProtocolProtos.ContainerBlocksDeletionACKProto deleteAck3 = blockDeletionACK;
            Consumer<CommandStatus> statusUpdater = cmdStatus -> {
                cmdStatus.setStatus(this.cmdExecuted);
                ((DeleteBlockCommandStatus)cmdStatus).setBlocksDeletionAck(deleteAck2);
            };
            this.updateCommandStatus(context, command, statusUpdater, LOG);
            long endTime = Time.monotonicNow();
            this.totalTime += endTime - startTime;
            ++this.invocationCount;
            throw throwable;
        }
        Consumer<CommandStatus> statusUpdater = cmdStatus -> {
            cmdStatus.setStatus(this.cmdExecuted);
            ((DeleteBlockCommandStatus)cmdStatus).setBlocksDeletionAck(deleteAck2);
        };
        this.updateCommandStatus(context, command, statusUpdater, LOG);
        long endTime = Time.monotonicNow();
        this.totalTime += endTime - startTime;
        ++this.invocationCount;
    }

    private void markBlocksForDeletionSchemaV2(KeyValueContainerData containerData, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTX, int newDeletionBlocks, long txnID) throws IOException {
        long containerId = delTX.getContainerID();
        if (!this.isTxnIdValid(containerId, containerData, delTX)) {
            return;
        }
        try (ReferenceCountedDB containerDB = BlockUtils.getDB(containerData, this.conf);){
            DatanodeStore ds = containerDB.getStore();
            DatanodeStoreSchemaTwoImpl dnStoreTwoImpl = (DatanodeStoreSchemaTwoImpl)ds;
            Table<Long, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction> delTxTable = dnStoreTwoImpl.getDeleteTransactionTable();
            try (BatchOperation batch = containerDB.getStore().getBatchHandler().initBatchOperation();){
                delTxTable.putWithBatch(batch, (Object)txnID, (Object)delTX);
                this.updateMetaData(containerData, delTX, newDeletionBlocks += delTX.getLocalIDList().size(), containerDB, batch);
                containerDB.getStore().getBatchHandler().commitBatchOperation(batch);
            }
        }
    }

    private void markBlocksForDeletionSchemaV1(KeyValueContainerData containerData, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTX) throws IOException {
        long containerId = delTX.getContainerID();
        if (!this.isTxnIdValid(containerId, containerData, delTX)) {
            return;
        }
        int newDeletionBlocks = 0;
        try (ReferenceCountedDB containerDB = BlockUtils.getDB(containerData, this.conf);){
            Table<String, BlockData> blockDataTable = containerDB.getStore().getBlockDataTable();
            Table<String, ChunkInfoList> deletedBlocksTable = containerDB.getStore().getDeletedBlocksTable();
            try (BatchOperation batch = containerDB.getStore().getBatchHandler().initBatchOperation();){
                for (Long blkLong : delTX.getLocalIDList()) {
                    String blk = blkLong.toString();
                    BlockData blkInfo = (BlockData)blockDataTable.get((Object)blk);
                    if (blkInfo != null) {
                        String deletingKey = "#deleting#" + blk;
                        if (blockDataTable.get((Object)deletingKey) != null || deletedBlocksTable.get((Object)blk) != null) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug(String.format("Ignoring delete for block %s in container %d. Entry already added.", blk, containerId));
                            continue;
                        }
                        blockDataTable.putWithBatch(batch, (Object)deletingKey, (Object)blkInfo);
                        blockDataTable.deleteWithBatch(batch, (Object)blk);
                        ++newDeletionBlocks;
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Transited Block {} to DELETING state in container {}", (Object)blk, (Object)containerId);
                        continue;
                    }
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Block {} not found or already under deletion in container {}, skip deleting it.", (Object)blk, (Object)containerId);
                }
                this.updateMetaData(containerData, delTX, newDeletionBlocks, containerDB, batch);
                containerDB.getStore().getBatchHandler().commitBatchOperation(batch);
            }
            catch (IOException e) {
                throw new IOException("Failed to delete blocks for TXID = " + delTX.getTxID(), e);
            }
        }
    }

    private void updateMetaData(KeyValueContainerData containerData, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTX, int newDeletionBlocks, ReferenceCountedDB containerDB, BatchOperation batchOperation) throws IOException {
        if (newDeletionBlocks > 0) {
            Table<String, Long> metadataTable = containerDB.getStore().getMetadataTable();
            if (delTX.getTxID() > containerData.getDeleteTransactionId()) {
                metadataTable.putWithBatch(batchOperation, (Object)"#delTX", (Object)delTX.getTxID());
            }
            long pendingDeleteBlocks = containerData.getNumPendingDeletionBlocks() + (long)newDeletionBlocks;
            metadataTable.putWithBatch(batchOperation, (Object)"#PENDINGDELETEBLOCKCOUNT", (Object)pendingDeleteBlocks);
            containerData.updateDeleteTransactionId(delTX.getTxID());
            containerData.incrPendingDeletionBlocks(newDeletionBlocks);
        }
    }

    private boolean isTxnIdValid(long containerId, KeyValueContainerData containerData, StorageContainerDatanodeProtocolProtos.DeletedBlocksTransaction delTX) {
        boolean b = true;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing Container : {}, DB path : {}", (Object)containerId, (Object)containerData.getMetadataPath());
        }
        if (delTX.getTxID() <= containerData.getDeleteTransactionId()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Ignoring delete blocks for containerId: %d. Outdated delete transactionId %d < %d", containerId, delTX.getTxID(), containerData.getDeleteTransactionId()));
            }
            b = false;
        }
        return b;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.deleteBlocksCommand;
    }

    @Override
    public int getInvocationCount() {
        return this.invocationCount;
    }

    @Override
    public long getAverageRunTime() {
        if (this.invocationCount > 0) {
            return this.totalTime / (long)this.invocationCount;
        }
        return 0L;
    }
}

