/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine.commandhandler;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.statemachine.SCMConnectionManager;
import org.apache.hadoop.ozone.container.common.statemachine.StateContext;
import org.apache.hadoop.ozone.container.common.statemachine.commandhandler.CommandHandler;
import org.apache.hadoop.ozone.container.ozoneimpl.ContainerController;
import org.apache.hadoop.ozone.container.ozoneimpl.OzoneContainer;
import org.apache.hadoop.ozone.protocol.commands.CloseContainerCommand;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;
import org.apache.hadoop.util.Time;
import org.apache.ratis.protocol.exceptions.NotLeaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseContainerCommandHandler
implements CommandHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CloseContainerCommandHandler.class);
    private AtomicLong invocationCount = new AtomicLong(0L);
    private long totalTime;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void handle(SCMCommand command, OzoneContainer ozoneContainer, StateContext context, SCMConnectionManager connectionManager) {
        LOG.debug("Processing Close Container command.");
        this.invocationCount.incrementAndGet();
        long startTime = Time.monotonicNow();
        DatanodeDetails datanodeDetails = context.getParent().getDatanodeDetails();
        StorageContainerDatanodeProtocolProtos.CloseContainerCommandProto closeCommand = ((CloseContainerCommand)command).getProto();
        ContainerController controller = ozoneContainer.getController();
        long containerId = closeCommand.getContainerID();
        try {
            Container container = controller.getContainer(containerId);
            if (container == null) {
                LOG.error("Container #{} does not exist in datanode. Container close failed.", (Object)containerId);
                return;
            }
            controller.markContainerForClose(containerId);
            switch (container.getContainerState()) {
                case OPEN: 
                case CLOSING: {
                    if (ozoneContainer.getWriteChannel().isExist(closeCommand.getPipelineID())) {
                        ContainerProtos.ContainerCommandRequestProto request = this.getContainerCommandRequestProto(datanodeDetails, closeCommand.getContainerID(), command.getEncodedToken());
                        ozoneContainer.getWriteChannel().submitRequest(request, closeCommand.getPipelineID());
                        return;
                    }
                    controller.markContainerUnhealthy(containerId);
                    LOG.info("Marking UNHEALTHY as Container should not be in CLOSING state without pipeline, ContainerID: {}", (Object)containerId);
                    return;
                }
                case QUASI_CLOSED: {
                    if (!closeCommand.getForce()) return;
                    controller.closeContainer(containerId);
                    return;
                }
                case CLOSED: {
                    return;
                }
                case UNHEALTHY: 
                case INVALID: {
                    if (!LOG.isDebugEnabled()) return;
                    LOG.debug("Cannot close the container #{}, the container is in {} state.", (Object)containerId, (Object)container.getContainerState());
                    return;
                }
            }
            return;
        }
        catch (NotLeaderException e) {
            LOG.debug("Follower cannot close container #{}.", (Object)containerId);
            return;
        }
        catch (IOException e) {
            LOG.error("Can't close container #{}", (Object)containerId, (Object)e);
            return;
        }
        finally {
            long endTime = Time.monotonicNow();
            this.totalTime += endTime - startTime;
        }
    }

    private ContainerProtos.ContainerCommandRequestProto getContainerCommandRequestProto(DatanodeDetails datanodeDetails, long containerId, String encodedToken) {
        ContainerProtos.ContainerCommandRequestProto.Builder command = ContainerProtos.ContainerCommandRequestProto.newBuilder();
        command.setCmdType(ContainerProtos.Type.CloseContainer);
        command.setTraceID(TracingUtil.exportCurrentSpan());
        command.setContainerID(containerId);
        command.setCloseContainer(ContainerProtos.CloseContainerRequestProto.getDefaultInstance());
        command.setDatanodeUuid(datanodeDetails.getUuidString());
        if (encodedToken != null) {
            command.setEncodedToken(encodedToken);
        }
        return command.build();
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getCommandType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.closeContainerCommand;
    }

    @Override
    public int getInvocationCount() {
        return (int)this.invocationCount.get();
    }

    @Override
    public long getAverageRunTime() {
        if (this.invocationCount.get() > 0L) {
            return this.totalTime / this.invocationCount.get();
        }
        return 0L;
    }
}

