/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.time.ZonedDateTime;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.ozone.container.common.statemachine.EndpointStateMachineMBean;
import org.apache.hadoop.ozone.protocol.VersionResponse;
import org.apache.hadoop.ozone.protocolPB.StorageContainerDatanodeProtocolClientSideTranslatorPB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointStateMachine
implements Closeable,
EndpointStateMachineMBean {
    static final Logger LOG = LoggerFactory.getLogger(EndpointStateMachine.class);
    private final StorageContainerDatanodeProtocolClientSideTranslatorPB endPoint;
    private final AtomicLong missedCount;
    private final InetSocketAddress address;
    private final Lock lock;
    private final ConfigurationSource conf;
    private EndPointStates state;
    private VersionResponse version;
    private ZonedDateTime lastSuccessfulHeartbeat;
    private boolean isPassive;
    private final ExecutorService executorService;

    public EndpointStateMachine(InetSocketAddress address, StorageContainerDatanodeProtocolClientSideTranslatorPB endPoint, ConfigurationSource conf) {
        this.endPoint = endPoint;
        this.missedCount = new AtomicLong(0L);
        this.address = address;
        this.state = EndPointStates.getInitState();
        this.lock = new ReentrantLock();
        this.conf = conf;
        this.executorService = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("EndpointStateMachine task thread for " + this.address + " - %d ").build());
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public VersionResponse getVersion() {
        return this.version;
    }

    public void setVersion(VersionResponse version) {
        this.version = version;
    }

    @Override
    public EndPointStates getState() {
        return this.state;
    }

    @Override
    public int getVersionNumber() {
        if (this.version != null) {
            return this.version.getProtobufMessage().getSoftwareVersion();
        }
        return -1;
    }

    public EndPointStates setState(EndPointStates epState) {
        this.state = epState;
        return this.state;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void close() throws IOException {
        if (this.endPoint != null) {
            this.endPoint.close();
        }
    }

    public void incMissed() {
        this.missedCount.incrementAndGet();
    }

    @Override
    public long getMissedCount() {
        return this.missedCount.get();
    }

    @Override
    public String getAddressString() {
        return this.getAddress().toString();
    }

    public void zeroMissedCount() {
        this.missedCount.set(0L);
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public StorageContainerDatanodeProtocolClientSideTranslatorPB getEndPoint() {
        return this.endPoint;
    }

    public String toString() {
        return this.address.toString();
    }

    public void logIfNeeded(Exception ex) {
        double missCounter = this.getMissedCount() % (long)HddsServerUtil.getLogWarnInterval((ConfigurationSource)this.conf);
        String serverName = "SCM";
        if (this.isPassive) {
            missCounter = this.getMissedCount() % (long)(10 * HddsServerUtil.getLogWarnInterval((ConfigurationSource)this.conf));
            serverName = "Recon";
        }
        if (missCounter == 0.0) {
            LOG.warn("Unable to communicate to {} server at {} for past {} seconds.", new Object[]{serverName, this.getAddress().getHostString() + ":" + this.getAddress().getPort(), TimeUnit.MILLISECONDS.toSeconds(this.getMissedCount() * HddsServerUtil.getScmHeartbeatInterval((ConfigurationSource)this.conf)), ex});
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Incrementing the Missed count.", (Throwable)ex);
        }
        this.incMissed();
    }

    public boolean isPassive() {
        return this.isPassive;
    }

    public void setPassive(boolean passive) {
        this.isPassive = passive;
    }

    @Override
    public long getLastSuccessfulHeartbeat() {
        return this.lastSuccessfulHeartbeat == null ? 0L : this.lastSuccessfulHeartbeat.toEpochSecond();
    }

    public void setLastSuccessfulHeartbeat(ZonedDateTime lastSuccessfulHeartbeat) {
        this.lastSuccessfulHeartbeat = lastSuccessfulHeartbeat;
    }

    public static enum EndPointStates {
        GETVERSION(1),
        REGISTER(2),
        HEARTBEAT(3),
        SHUTDOWN(4);

        private final int value;

        private EndPointStates(int value) {
            this.value = value;
        }

        public static EndPointStates getInitState() {
            return GETVERSION;
        }

        public static EndPointStates getLastState() {
            return SHUTDOWN;
        }

        public int getValue() {
            return this.value;
        }

        public EndPointStates getNextState() {
            if (this.getValue() < EndPointStates.getLastState().getValue()) {
                int stateValue = this.getValue() + 1;
                for (EndPointStates iter : EndPointStates.values()) {
                    if (stateValue != iter.getValue()) continue;
                    return iter;
                }
            }
            return EndPointStates.getLastState();
        }
    }
}

