/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.statemachine;

import java.time.Duration;
import org.apache.hadoop.hdds.conf.Config;
import org.apache.hadoop.hdds.conf.ConfigGroup;
import org.apache.hadoop.hdds.conf.ConfigTag;
import org.apache.hadoop.hdds.conf.ConfigType;
import org.apache.hadoop.hdds.conf.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfigGroup(prefix="hdds.datanode")
public class DatanodeConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeConfiguration.class);
    static final String REPLICATION_STREAMS_LIMIT_KEY = "hdds.datanode.replication.streams.limit";
    static final String CONTAINER_DELETE_THREADS_MAX_KEY = "hdds.datanode.container.delete.threads.max";
    static final String PERIODIC_DISK_CHECK_INTERVAL_MINUTES_KEY = "hdds.datanode.periodic.disk.check.interval.minutes";
    public static final String FAILED_DATA_VOLUMES_TOLERATED_KEY = "hdds.datanode.failed.data.volumes.tolerated";
    public static final String FAILED_METADATA_VOLUMES_TOLERATED_KEY = "hdds.datanode.failed.metadata.volumes.tolerated";
    public static final String DISK_CHECK_MIN_GAP_KEY = "hdds.datanode.disk.check.min.gap";
    public static final String DISK_CHECK_TIMEOUT_KEY = "hdds.datanode.disk.check.timeout";
    static final boolean CHUNK_DATA_VALIDATION_CHECK_DEFAULT = false;
    static final int REPLICATION_MAX_STREAMS_DEFAULT = 10;
    static final long PERIODIC_DISK_CHECK_INTERVAL_MINUTES_DEFAULT = 60L;
    static final int FAILED_VOLUMES_TOLERATED_DEFAULT = -1;
    static final long DISK_CHECK_MIN_GAP_DEFAULT = Duration.ofMinutes(15L).toMillis();
    static final long DISK_CHECK_TIMEOUT_DEFAULT = Duration.ofMinutes(10L).toMillis();
    @Config(key="replication.streams.limit", type=ConfigType.INT, defaultValue="10", tags={ConfigTag.DATANODE}, description="The maximum number of replication commands a single datanode can execute simultaneously")
    private int replicationMaxStreams = 10;
    static final int CONTAINER_DELETE_THREADS_DEFAULT = 2;
    @Config(key="container.delete.threads.max", type=ConfigType.INT, defaultValue="2", tags={ConfigTag.DATANODE}, description="The maximum number of threads used to delete containers on a datanode")
    private int containerDeleteThreads = 2;
    @Config(key="block.deleting.service.interval", defaultValue="60s", type=ConfigType.TIME, tags={ConfigTag.SCM, ConfigTag.DELETION}, description="Time interval of the Datanode block deleting service. The block deleting service runs on Datanode periodically and deletes blocks queued for deletion. Unit could be defined with postfix (ns,ms,s,m,h,d). ")
    private long blockDeletionInterval = Duration.ofSeconds(60L).toMillis();
    @Config(key="block.deleting.limit.per.interval", defaultValue="5000", type=ConfigType.INT, tags={ConfigTag.SCM, ConfigTag.DELETION}, description="Number of blocks to be deleted in an interval.")
    private int blockLimitPerInterval = 5000;
    @Config(key="periodic.disk.check.interval.minutes", defaultValue="60", type=ConfigType.LONG, tags={ConfigTag.DATANODE}, description="Periodic disk check run interval in minutes.")
    private long periodicDiskCheckIntervalMinutes = 60L;
    @Config(key="failed.data.volumes.tolerated", defaultValue="-1", type=ConfigType.INT, tags={ConfigTag.DATANODE}, description="The number of data volumes that are allowed to fail before a datanode stops offering service. Config this to -1 means unlimited, but we should have at least one good volume left.")
    private int failedDataVolumesTolerated = -1;
    @Config(key="failed.metadata.volumes.tolerated", defaultValue="-1", type=ConfigType.INT, tags={ConfigTag.DATANODE}, description="The number of metadata volumes that are allowed to fail before a datanode stops offering service. Config this to -1 means unlimited, but we should have at least one good volume left.")
    private int failedMetadataVolumesTolerated = -1;
    @Config(key="disk.check.min.gap", defaultValue="15m", type=ConfigType.TIME, tags={ConfigTag.DATANODE}, description="The minimum gap between two successive checks of the same Datanode volume. Unit could be defined with postfix (ns,ms,s,m,h,d).")
    private long diskCheckMinGap = DISK_CHECK_MIN_GAP_DEFAULT;
    @Config(key="disk.check.timeout", defaultValue="10m", type=ConfigType.TIME, tags={ConfigTag.DATANODE}, description="Maximum allowed time for a disk check to complete. If the check does not complete within this time interval then the disk is declared as failed. Unit could be defined with postfix (ns,ms,s,m,h,d).")
    private long diskCheckTimeout = DISK_CHECK_TIMEOUT_DEFAULT;
    @Config(key="chunk.data.validation.check", defaultValue="false", type=ConfigType.BOOLEAN, tags={ConfigTag.DATANODE}, description="Enable safety checks such as checksum validation for Ratis calls.")
    private boolean isChunkDataValidationCheck = false;

    public Duration getBlockDeletionInterval() {
        return Duration.ofMillis(this.blockDeletionInterval);
    }

    public void setBlockDeletionInterval(Duration duration) {
        this.blockDeletionInterval = duration.toMillis();
    }

    public int getBlockDeletionLimit() {
        return this.blockLimitPerInterval;
    }

    public void setBlockDeletionLimit(int limit) {
        this.blockLimitPerInterval = limit;
    }

    @PostConstruct
    public void validate() {
        if (this.replicationMaxStreams < 1) {
            LOG.warn("hdds.datanode.replication.streams.limit must be greater than zero and was set to {}. Defaulting to {}", (Object)this.replicationMaxStreams, (Object)10);
            this.replicationMaxStreams = 10;
        }
        if (this.containerDeleteThreads < 1) {
            LOG.warn("hdds.datanode.container.delete.threads.max must be greater than zero and was set to {}. Defaulting to {}", (Object)this.containerDeleteThreads, (Object)2);
            this.containerDeleteThreads = 2;
        }
        if (this.periodicDiskCheckIntervalMinutes < 1L) {
            LOG.warn("hdds.datanode.periodic.disk.check.interval.minutes must be greater than zero and was set to {}. Defaulting to {}", (Object)this.periodicDiskCheckIntervalMinutes, (Object)60L);
            this.periodicDiskCheckIntervalMinutes = 60L;
        }
        if (this.failedDataVolumesTolerated < -1) {
            LOG.warn("hdds.datanode.failed.data.volumes.toleratedmust be greater than -1 and was set to {}. Defaulting to {}", (Object)this.failedDataVolumesTolerated, (Object)-1);
            this.failedDataVolumesTolerated = -1;
        }
        if (this.failedMetadataVolumesTolerated < -1) {
            LOG.warn("hdds.datanode.failed.metadata.volumes.toleratedmust be greater than -1 and was set to {}. Defaulting to {}", (Object)this.failedMetadataVolumesTolerated, (Object)-1);
            this.failedMetadataVolumesTolerated = -1;
        }
        if (this.diskCheckMinGap < 0L) {
            LOG.warn("hdds.datanode.disk.check.min.gap must be greater than zero and was set to {}. Defaulting to {}", (Object)this.diskCheckMinGap, (Object)DISK_CHECK_MIN_GAP_DEFAULT);
            this.diskCheckMinGap = DISK_CHECK_MIN_GAP_DEFAULT;
        }
        if (this.diskCheckTimeout < 0L) {
            LOG.warn("hdds.datanode.disk.check.timeout must be greater than zero and was set to {}. Defaulting to {}", (Object)this.diskCheckTimeout, (Object)DISK_CHECK_TIMEOUT_DEFAULT);
            this.diskCheckTimeout = DISK_CHECK_TIMEOUT_DEFAULT;
        }
    }

    public void setReplicationMaxStreams(int replicationMaxStreams) {
        this.replicationMaxStreams = replicationMaxStreams;
    }

    public void setContainerDeleteThreads(int containerDeleteThreads) {
        this.containerDeleteThreads = containerDeleteThreads;
    }

    public int getReplicationMaxStreams() {
        return this.replicationMaxStreams;
    }

    public int getContainerDeleteThreads() {
        return this.containerDeleteThreads;
    }

    public long getPeriodicDiskCheckIntervalMinutes() {
        return this.periodicDiskCheckIntervalMinutes;
    }

    public void setPeriodicDiskCheckIntervalMinutes(long periodicDiskCheckIntervalMinutes) {
        this.periodicDiskCheckIntervalMinutes = periodicDiskCheckIntervalMinutes;
    }

    public int getFailedDataVolumesTolerated() {
        return this.failedDataVolumesTolerated;
    }

    public void setFailedDataVolumesTolerated(int failedVolumesTolerated) {
        this.failedDataVolumesTolerated = failedVolumesTolerated;
    }

    public int getFailedMetadataVolumesTolerated() {
        return this.failedMetadataVolumesTolerated;
    }

    public void setFailedMetadataVolumesTolerated(int failedVolumesTolerated) {
        this.failedMetadataVolumesTolerated = failedVolumesTolerated;
    }

    public Duration getDiskCheckMinGap() {
        return Duration.ofMillis(this.diskCheckMinGap);
    }

    public void setDiskCheckMinGap(Duration duration) {
        this.diskCheckMinGap = duration.toMillis();
    }

    public Duration getDiskCheckTimeout() {
        return Duration.ofMillis(this.diskCheckTimeout);
    }

    public void setDiskCheckTimeout(Duration duration) {
        this.diskCheckTimeout = duration.toMillis();
    }

    public boolean isChunkDataValidationCheck() {
        return this.isChunkDataValidationCheck;
    }

    public void setChunkDataValidationCheck(boolean writeChunkValidationCheck) {
        this.isChunkDataValidationCheck = writeChunkValidationCheck;
    }
}

