/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.report;

import com.google.protobuf.GeneratedMessage;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.container.common.report.CRLStatusReportPublisher;
import org.apache.hadoop.ozone.container.common.report.CommandStatusReportPublisher;
import org.apache.hadoop.ozone.container.common.report.ContainerReportPublisher;
import org.apache.hadoop.ozone.container.common.report.NodeReportPublisher;
import org.apache.hadoop.ozone.container.common.report.PipelineReportPublisher;
import org.apache.hadoop.ozone.container.common.report.ReportPublisher;

public class ReportPublisherFactory {
    private final ConfigurationSource conf;
    private final Map<Class<? extends GeneratedMessage>, Class<? extends ReportPublisher>> report2publisher;

    public ReportPublisherFactory(ConfigurationSource conf) {
        this.conf = conf;
        this.report2publisher = new HashMap<Class<? extends GeneratedMessage>, Class<? extends ReportPublisher>>();
        this.report2publisher.put(StorageContainerDatanodeProtocolProtos.NodeReportProto.class, NodeReportPublisher.class);
        this.report2publisher.put(StorageContainerDatanodeProtocolProtos.ContainerReportsProto.class, ContainerReportPublisher.class);
        this.report2publisher.put(StorageContainerDatanodeProtocolProtos.CommandStatusReportsProto.class, CommandStatusReportPublisher.class);
        this.report2publisher.put(StorageContainerDatanodeProtocolProtos.PipelineReportsProto.class, PipelineReportPublisher.class);
        this.report2publisher.put(StorageContainerDatanodeProtocolProtos.CRLStatusReport.class, CRLStatusReportPublisher.class);
    }

    public ReportPublisher getPublisherFor(Class<? extends GeneratedMessage> report) {
        Class<? extends ReportPublisher> publisherClass = this.report2publisher.get(report);
        if (publisherClass == null) {
            throw new RuntimeException("No publisher found for report " + report);
        }
        try {
            ReportPublisher reportPublisher = publisherClass.newInstance();
            reportPublisher.setConf(this.conf);
            return reportPublisher;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

