/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDeletionChoosingPolicy;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.statemachine.background.BlockDeletingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopNOrderedContainerDeletionChoosingPolicy
implements ContainerDeletionChoosingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(TopNOrderedContainerDeletionChoosingPolicy.class);
    private static final Comparator<KeyValueContainerData> KEY_VALUE_CONTAINER_DATA_COMPARATOR = (c1, c2) -> Long.compare(c2.getNumPendingDeletionBlocks(), c1.getNumPendingDeletionBlocks());

    @Override
    public List<BlockDeletingService.ContainerBlockInfo> chooseContainerForBlockDeletion(int totalBlocks, Map<Long, ContainerData> candidateContainers) throws StorageContainerException {
        Preconditions.checkNotNull(candidateContainers, (Object)"Internal assertion: candidate containers cannot be null");
        ArrayList<BlockDeletingService.ContainerBlockInfo> result = new ArrayList<BlockDeletingService.ContainerBlockInfo>();
        LinkedList<KeyValueContainerData> orderedList = new LinkedList<KeyValueContainerData>();
        for (ContainerData containerData : candidateContainers.values()) {
            orderedList.add((KeyValueContainerData)containerData);
        }
        Collections.sort(orderedList, KEY_VALUE_CONTAINER_DATA_COMPARATOR);
        for (KeyValueContainerData keyValueContainerData : orderedList) {
            if (keyValueContainerData.getNumPendingDeletionBlocks() > 0L) {
                long numBlocksToDelete = Math.min((long)totalBlocks, keyValueContainerData.getNumPendingDeletionBlocks());
                totalBlocks = (int)((long)totalBlocks - numBlocksToDelete);
                result.add(new BlockDeletingService.ContainerBlockInfo(keyValueContainerData, numBlocksToDelete));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Select container {} for block deletion, pending deletion blocks num: {}.", (Object)keyValueContainerData.getContainerID(), (Object)keyValueContainerData.getNumPendingDeletionBlocks());
                }
                if (totalBlocks != 0) continue;
                break;
            }
            LOG.debug("Stop looking for next container, there is no pending deletion block contained in remaining containers.");
            break;
        }
        return result;
    }
}

