/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.interfaces.ContainerDeletionChoosingPolicy;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.apache.hadoop.ozone.container.keyvalue.statemachine.background.BlockDeletingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomContainerDeletionChoosingPolicy
implements ContainerDeletionChoosingPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(RandomContainerDeletionChoosingPolicy.class);

    @Override
    public List<BlockDeletingService.ContainerBlockInfo> chooseContainerForBlockDeletion(int blockCount, Map<Long, ContainerData> candidateContainers) throws StorageContainerException {
        Preconditions.checkNotNull(candidateContainers, (Object)"Internal assertion: candidate containers cannot be null");
        ArrayList<BlockDeletingService.ContainerBlockInfo> result = new ArrayList<BlockDeletingService.ContainerBlockInfo>();
        ContainerData[] values = new ContainerData[candidateContainers.size()];
        Object[] shuffled = candidateContainers.values().toArray(values);
        ArrayUtils.shuffle((Object[])shuffled);
        for (Object entry : shuffled) {
            if (((KeyValueContainerData)entry).getNumPendingDeletionBlocks() <= 0L) continue;
            long numBlocksToDelete = Math.min((long)blockCount, ((KeyValueContainerData)entry).getNumPendingDeletionBlocks());
            blockCount = (int)((long)blockCount - numBlocksToDelete);
            result.add(new BlockDeletingService.ContainerBlockInfo((ContainerData)entry, numBlocksToDelete));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Select container {} for block deletion, pending deletion blocks num: {}.", (Object)((ContainerData)entry).getContainerID(), (Object)((KeyValueContainerData)entry).getNumPendingDeletionBlocks());
            }
            if (blockCount == 0) break;
        }
        return result;
    }
}

