/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.common.impl.ContainerDataScanOrder;
import org.apache.hadoop.ozone.container.common.interfaces.Container;
import org.apache.hadoop.ozone.container.common.volume.HddsVolume;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerSet {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerSet.class);
    private final ConcurrentSkipListMap<Long, Container<?>> containerMap = new ConcurrentSkipListMap();
    private final ConcurrentSkipListSet<Long> missingContainerSet = new ConcurrentSkipListSet();

    public boolean addContainer(Container<?> container) throws StorageContainerException {
        Preconditions.checkNotNull(container, (Object)"container cannot be null");
        long containerId = ((ContainerData)container.getContainerData()).getContainerID();
        if (this.containerMap.putIfAbsent(containerId, container) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Container with container Id {} is added to containerMap", (Object)containerId);
            }
            ((ContainerData)container.getContainerData()).commitSpace();
            return true;
        }
        LOG.warn("Container already exists with container Id {}", (Object)containerId);
        throw new StorageContainerException("Container already exists with container Id " + containerId, ContainerProtos.Result.CONTAINER_EXISTS);
    }

    public Container<?> getContainer(long containerId) {
        Preconditions.checkState((containerId >= 0L ? 1 : 0) != 0, (Object)"Container Id cannot be negative.");
        return this.containerMap.get(containerId);
    }

    public boolean removeContainer(long containerId) {
        Preconditions.checkState((containerId >= 0L ? 1 : 0) != 0, (Object)"Container Id cannot be negative.");
        Container<?> removed = this.containerMap.remove(containerId);
        if (removed == null) {
            LOG.debug("Container with containerId {} is not present in containerMap", (Object)containerId);
            return false;
        }
        LOG.debug("Container with containerId {} is removed from containerMap", (Object)containerId);
        return true;
    }

    @VisibleForTesting
    public int containerCount() {
        return this.containerMap.size();
    }

    public void handleVolumeFailures() {
        this.containerMap.values().forEach(c -> {
            if (((ContainerData)c.getContainerData()).getVolume().isFailed()) {
                try {
                    c.markContainerUnhealthy();
                    LOG.info("Marking Container {} UNHEALTHY as the Volume {} has failed", (Object)((ContainerData)c.getContainerData()).getContainerID(), (Object)((ContainerData)c.getContainerData()).getVolume());
                }
                catch (StorageContainerException e) {
                    LOG.error("Failed to move container {} to UNHEALTHY state in volume {}", new Object[]{((ContainerData)c.getContainerData()).getContainerID(), ((ContainerData)c.getContainerData()).getVolume(), e});
                }
            }
        });
    }

    public Iterator<Container<?>> getContainerIterator() {
        return this.containerMap.values().iterator();
    }

    public Iterator<Container<?>> getContainerIterator(HddsVolume volume) {
        Preconditions.checkNotNull((Object)volume);
        Preconditions.checkNotNull((Object)volume.getStorageID());
        String volumeUuid = volume.getStorageID();
        return this.containerMap.values().stream().filter(x -> volumeUuid.equals(((ContainerData)x.getContainerData()).getVolume().getStorageID())).sorted(ContainerDataScanOrder.INSTANCE).iterator();
    }

    public Iterator<Map.Entry<Long, Container<?>>> getContainerMapIterator() {
        return this.containerMap.entrySet().iterator();
    }

    @VisibleForTesting
    public Map<Long, Container<?>> getContainerMapCopy() {
        return ImmutableMap.copyOf(this.containerMap);
    }

    public Map<Long, Container<?>> getContainerMap() {
        return Collections.unmodifiableMap(this.containerMap);
    }

    public void listContainer(long startContainerId, long count, List<ContainerData> data) throws StorageContainerException {
        Preconditions.checkNotNull(data, (Object)"Internal assertion: data cannot be null");
        Preconditions.checkState((startContainerId >= 0L ? 1 : 0) != 0, (Object)"Start container Id cannot be negative");
        Preconditions.checkState((count > 0L ? 1 : 0) != 0, (Object)"max number of containers returned must be positive");
        LOG.debug("listContainer returns containerData starting from {} of count {}", (Object)startContainerId, (Object)count);
        NavigableMap<Long, Container<Object>> map = startContainerId == 0L ? this.containerMap : this.containerMap.tailMap((Object)startContainerId, true);
        int currentCount = 0;
        for (Container entry : map.values()) {
            if ((long)currentCount < count) {
                data.add((ContainerData)entry.getContainerData());
                ++currentCount;
                continue;
            }
            return;
        }
    }

    public StorageContainerDatanodeProtocolProtos.ContainerReportsProto getContainerReport() throws IOException {
        LOG.debug("Starting container report iteration.");
        ArrayList containers = new ArrayList(this.containerMap.values());
        StorageContainerDatanodeProtocolProtos.ContainerReportsProto.Builder crBuilder = StorageContainerDatanodeProtocolProtos.ContainerReportsProto.newBuilder();
        for (Container container : containers) {
            crBuilder.addReports(container.getContainerReport());
        }
        return crBuilder.build();
    }

    public Set<Long> getMissingContainerSet() {
        return this.missingContainerSet;
    }

    public void buildMissingContainerSetAndValidate(Map<Long, Long> container2BCSIDMap) {
        container2BCSIDMap.entrySet().parallelStream().forEach(mapEntry -> {
            long id = (Long)mapEntry.getKey();
            if (!this.containerMap.containsKey(id)) {
                LOG.warn("Adding container {} to missing container set.", (Object)id);
                this.missingContainerSet.add(id);
            } else {
                long snapshotBCSID;
                Container<?> container = this.containerMap.get(id);
                long containerBCSID = container.getBlockCommitSequenceId();
                if (containerBCSID < (snapshotBCSID = ((Long)mapEntry.getValue()).longValue())) {
                    LOG.warn("Marking container {} unhealthy as reported BCSID {} is smaller than ratis snapshot recorded value {}", new Object[]{id, containerBCSID, snapshotBCSID});
                    try {
                        container.markContainerUnhealthy();
                    }
                    catch (StorageContainerException sce) {
                        LOG.error("Unable to persist unhealthy state for container {}", (Object)id);
                    }
                }
            }
        });
    }
}

