/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.impl.ChunkLayOutVersion;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.apache.hadoop.ozone.container.keyvalue.KeyValueContainerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.introspector.PropertyUtils;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.representer.Representer;

public final class ContainerDataYaml {
    private static final Logger LOG = LoggerFactory.getLogger(ContainerDataYaml.class);

    private ContainerDataYaml() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createContainerFile(ContainerProtos.ContainerType containerType, ContainerData containerData, File containerFile) throws IOException {
        Writer writer = null;
        FileOutputStream out = null;
        try {
            Yaml yaml = ContainerDataYaml.getYamlForContainerType(containerType);
            containerData.computeAndSetChecksum(yaml);
            out = new FileOutputStream(containerFile);
            writer = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
            yaml.dump((Object)containerData, writer);
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    writer.flush();
                    out.getFD().sync();
                    writer.close();
                }
            }
            catch (IOException ex) {
                LOG.warn("Error occurred during closing the writer. ContainerID: " + containerData.getContainerID());
            }
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        try {
            if (writer != null) {
                writer.flush();
                out.getFD().sync();
                writer.close();
            }
        }
        catch (IOException ex) {
            LOG.warn("Error occurred during closing the writer. ContainerID: " + containerData.getContainerID());
        }
        IOUtils.closeQuietly((OutputStream)out);
    }

    public static ContainerData readContainerFile(File containerFile) throws IOException {
        Preconditions.checkNotNull((Object)containerFile, (Object)"containerFile cannot be null");
        try (FileInputStream inputFileStream = new FileInputStream(containerFile);){
            ContainerData containerData = ContainerDataYaml.readContainer(inputFileStream);
            return containerData;
        }
    }

    public static ContainerData readContainer(byte[] containerFileContent) throws IOException {
        return ContainerDataYaml.readContainer(new ByteArrayInputStream(containerFileContent));
    }

    public static ContainerData readContainer(InputStream input) throws IOException {
        PropertyUtils propertyUtils = new PropertyUtils();
        propertyUtils.setBeanAccess(BeanAccess.FIELD);
        propertyUtils.setAllowReadOnlyProperties(true);
        ContainerDataRepresenter representer = new ContainerDataRepresenter();
        representer.setPropertyUtils(propertyUtils);
        ContainerDataConstructor containerDataConstructor = new ContainerDataConstructor();
        Yaml yaml = new Yaml((BaseConstructor)containerDataConstructor, (Representer)representer);
        yaml.setBeanAccess(BeanAccess.FIELD);
        ContainerData containerData = (ContainerData)yaml.load(input);
        return containerData;
    }

    public static Yaml getYamlForContainerType(ContainerProtos.ContainerType containerType) throws StorageContainerException {
        PropertyUtils propertyUtils = new PropertyUtils();
        propertyUtils.setBeanAccess(BeanAccess.FIELD);
        propertyUtils.setAllowReadOnlyProperties(true);
        switch (containerType) {
            case KeyValueContainer: {
                ContainerDataRepresenter representer = new ContainerDataRepresenter();
                representer.setPropertyUtils(propertyUtils);
                representer.addClassTag(KeyValueContainerData.class, KeyValueContainerData.KEYVALUE_YAML_TAG);
                ContainerDataConstructor keyValueDataConstructor = new ContainerDataConstructor();
                return new Yaml((BaseConstructor)keyValueDataConstructor, (Representer)representer);
            }
        }
        throw new StorageContainerException("Unrecognized container Type format " + containerType, ContainerProtos.Result.UNKNOWN_CONTAINER_TYPE);
    }

    private static class ContainerDataConstructor
    extends Constructor {
        ContainerDataConstructor() {
            this.yamlConstructors.put(KeyValueContainerData.KEYVALUE_YAML_TAG, new ConstructKeyValueContainerData());
            this.yamlConstructors.put(Tag.INT, new ConstructLong());
        }

        private Number createNumber(int sign, String number, int radix) {
            if (sign < 0) {
                number = "-" + number;
            }
            Long result = Long.valueOf(number, radix);
            return result;
        }

        private class ConstructLong
        extends AbstractConstruct {
            private ConstructLong() {
            }

            public Object construct(Node node) {
                String value = ContainerDataConstructor.this.constructScalar((ScalarNode)node).toString().replaceAll("_", "");
                int sign = 1;
                char first = value.charAt(0);
                if (first == '-') {
                    sign = -1;
                    value = value.substring(1);
                } else if (first == '+') {
                    value = value.substring(1);
                }
                int base = 10;
                if ("0".equals(value)) {
                    return 0L;
                }
                if (value.startsWith("0b")) {
                    value = value.substring(2);
                    base = 2;
                } else if (value.startsWith("0x")) {
                    value = value.substring(2);
                    base = 16;
                } else if (value.startsWith("0")) {
                    value = value.substring(1);
                    base = 8;
                } else {
                    if (value.indexOf(58) != -1) {
                        String[] digits = value.split(":");
                        int bes = 1;
                        int val = 0;
                        int j = digits.length;
                        for (int i = 0; i < j; ++i) {
                            val = (int)((long)val + Long.parseLong(digits[j - i - 1]) * (long)bes);
                            bes *= 60;
                        }
                        return ContainerDataConstructor.this.createNumber(sign, String.valueOf(val), 10);
                    }
                    return ContainerDataConstructor.this.createNumber(sign, value, 10);
                }
                return ContainerDataConstructor.this.createNumber(sign, value, base);
            }
        }

        private class ConstructKeyValueContainerData
        extends AbstractConstruct {
            private ConstructKeyValueContainerData() {
            }

            public Object construct(Node node) {
                MappingNode mnode = (MappingNode)node;
                Map nodes = ContainerDataConstructor.this.constructMapping(mnode);
                long layOutVersion = (Long)nodes.get("layOutVersion");
                ChunkLayOutVersion layoutVersion = ChunkLayOutVersion.getChunkLayOutVersion((int)layOutVersion);
                long size = (Long)nodes.get("maxSize");
                String originPipelineId = (String)nodes.get("originPipelineId");
                String originNodeId = (String)nodes.get("originNodeId");
                KeyValueContainerData kvData = new KeyValueContainerData((Long)nodes.get("containerID"), layoutVersion, size, originPipelineId, originNodeId);
                kvData.setContainerDBType((String)nodes.get("containerDBType"));
                kvData.setMetadataPath((String)nodes.get("metadataPath"));
                kvData.setChunksPath((String)nodes.get("chunksPath"));
                Map meta = (Map)nodes.get("metadata");
                kvData.setMetadata(meta);
                kvData.setChecksum((String)nodes.get("checksum"));
                Long timestamp = (Long)nodes.get("dataScanTimestamp");
                kvData.setDataScanTimestamp(timestamp);
                String state = (String)nodes.get("state");
                kvData.setState(ContainerProtos.ContainerDataProto.State.valueOf((String)state));
                String schemaVersion = (String)nodes.get("schemaVersion");
                kvData.setSchemaVersion(schemaVersion);
                return kvData;
            }
        }
    }

    private static class ContainerDataRepresenter
    extends Representer {
        private ContainerDataRepresenter() {
        }

        protected Set<Property> getProperties(Class<? extends Object> type) {
            Set set = super.getProperties(type);
            TreeSet<Property> filtered = new TreeSet<Property>();
            if (type.equals(KeyValueContainerData.class)) {
                List<String> yamlFields = KeyValueContainerData.getYamlFields();
                for (Property prop : set) {
                    String name = prop.getName();
                    if (!yamlFields.contains(name)) continue;
                    filtered.add(prop);
                }
            }
            return filtered;
        }

        protected NodeTuple representJavaBeanProperty(Object bean, Property property, Object value, Tag tag) {
            return value == null ? null : super.representJavaBeanProperty(bean, property, value, tag);
        }
    }
}

