/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.container.common.impl;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.apache.hadoop.hdds.client.BlockID;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.scm.container.common.helpers.StorageContainerException;
import org.apache.hadoop.ozone.container.common.helpers.ChunkInfo;
import org.apache.hadoop.ozone.container.common.impl.ContainerData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ChunkLayOutVersion {
    FILE_PER_CHUNK(1, "One file per chunk"){

        @Override
        public File getChunkFile(File chunkDir, BlockID blockID, ChunkInfo info) {
            return new File(chunkDir, info.getChunkName());
        }
    }
    ,
    FILE_PER_BLOCK(2, "One file per block"){

        @Override
        public File getChunkFile(File chunkDir, BlockID blockID, ChunkInfo info) {
            return new File(chunkDir, blockID.getLocalID() + ".block");
        }
    };

    private static final Logger LOG;
    private static final ChunkLayOutVersion DEFAULT_LAYOUT;
    private static final List<ChunkLayOutVersion> CHUNK_LAYOUT_VERSIONS;
    private final int version;
    private final String description;

    private ChunkLayOutVersion(int version, String description) {
        this.version = version;
        this.description = description;
    }

    public static ChunkLayOutVersion getChunkLayOutVersion(int chunkVersion) {
        for (ChunkLayOutVersion chunkLayOutVersion : CHUNK_LAYOUT_VERSIONS) {
            if (chunkLayOutVersion.getVersion() != chunkVersion) continue;
            return chunkLayOutVersion;
        }
        return null;
    }

    public static List<ChunkLayOutVersion> getAllVersions() {
        return CHUNK_LAYOUT_VERSIONS;
    }

    public static ChunkLayOutVersion getConfiguredVersion(ConfigurationSource conf) {
        try {
            return (ChunkLayOutVersion)conf.getEnum("ozone.scm.chunk.layout", (Enum)DEFAULT_LAYOUT);
        }
        catch (IllegalArgumentException e) {
            return DEFAULT_LAYOUT;
        }
    }

    public int getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract File getChunkFile(File var1, BlockID var2, ChunkInfo var3);

    public File getChunkFile(ContainerData containerData, BlockID blockID, ChunkInfo info) throws StorageContainerException {
        File chunkDir = ChunkLayOutVersion.getChunkDir(containerData);
        return this.getChunkFile(chunkDir, blockID, info);
    }

    public String toString() {
        return "ChunkLayout:v" + this.version;
    }

    private static File getChunkDir(ContainerData containerData) throws StorageContainerException {
        Preconditions.checkNotNull((Object)containerData, (Object)"Container data can't be null");
        String chunksPath = containerData.getChunksPath();
        if (chunksPath == null) {
            LOG.error("Chunks path is null in the container data");
            throw new StorageContainerException("Unable to get Chunks directory.", ContainerProtos.Result.UNABLE_TO_FIND_DATA_DIR);
        }
        return new File(chunksPath);
    }

    static {
        LOG = LoggerFactory.getLogger(ChunkLayOutVersion.class);
        DEFAULT_LAYOUT = FILE_PER_BLOCK;
        CHUNK_LAYOUT_VERSIONS = ImmutableList.copyOf((Object[])ChunkLayOutVersion.values());
    }
}

