/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.datanode.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.datanode.metadata.CRLDBDefinition;
import org.apache.hadoop.hdds.datanode.metadata.DatanodeCRLStore;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatanodeCRLStoreImpl
implements DatanodeCRLStore {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeCRLStore.class);
    private DBStore store;
    private Table<String, Long> crlSequenceIdTable;
    private Table<Long, CRLInfo> pendingCRLsTable;

    public DatanodeCRLStoreImpl(OzoneConfiguration configuration) throws IOException {
        this.start(configuration);
    }

    @Override
    public void start(OzoneConfiguration configuration) throws IOException {
        if (this.store == null) {
            this.store = DBStoreBuilder.createDBStore((ConfigurationSource)configuration, (DBDefinition)new CRLDBDefinition());
            this.crlSequenceIdTable = CRLDBDefinition.CRL_SEQUENCE_ID.getTable(this.store);
            this.checkTableStatus(this.crlSequenceIdTable, CRLDBDefinition.CRL_SEQUENCE_ID.getName());
            this.pendingCRLsTable = CRLDBDefinition.PENDING_CRLS.getTable(this.store);
            this.checkTableStatus(this.pendingCRLsTable, CRLDBDefinition.PENDING_CRLS.getName());
        }
    }

    @Override
    public void stop() throws Exception {
        if (this.store != null) {
            this.store.close();
            this.store = null;
        }
    }

    @Override
    public DBStore getStore() {
        return this.store;
    }

    @Override
    public Table<String, Long> getCRLSequenceIdTable() {
        return this.crlSequenceIdTable;
    }

    @Override
    public Table<Long, CRLInfo> getPendingCRLsTable() {
        return this.pendingCRLsTable;
    }

    @Override
    public Long getLatestCRLSequenceID() throws IOException {
        Long sequenceId = (Long)this.crlSequenceIdTable.get((Object)"CRL_SEQUENCE_ID");
        if (sequenceId == null) {
            return 0L;
        }
        return sequenceId;
    }

    @Override
    public List<CRLInfo> getPendingCRLs() throws IOException {
        TableIterator iter = this.pendingCRLsTable.iterator();
        ArrayList<CRLInfo> pendingCRLs = new ArrayList<CRLInfo>();
        while (iter.hasNext()) {
            pendingCRLs.add((CRLInfo)((Table.KeyValue)iter.next()).getValue());
        }
        return pendingCRLs;
    }

    private void checkTableStatus(Table table, String name) throws IOException {
        String logMessage = "Unable to get a reference to %s table. Cannot continue.";
        String errMsg = "Inconsistent DB state, Table - %s. Please check the logsfor more info.";
        if (table == null) {
            LOG.error(String.format(logMessage, name));
            throw new IOException(String.format(errMsg, name));
        }
    }
}

