/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.datanode.metadata;

import com.google.common.base.Preconditions;
import java.io.File;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfoCodec;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.LongCodec;
import org.apache.hadoop.hdds.utils.db.StringCodec;

public class CRLDBDefinition
implements DBDefinition {
    public static final DBColumnFamilyDefinition<Long, CRLInfo> PENDING_CRLS = new DBColumnFamilyDefinition("pendingCrls", Long.class, (Codec)new LongCodec(), CRLInfo.class, (Codec)new CRLInfoCodec());
    public static final DBColumnFamilyDefinition<String, Long> CRL_SEQUENCE_ID = new DBColumnFamilyDefinition("crlSequenceId", String.class, (Codec)new StringCodec(), Long.class, (Codec)new LongCodec());

    public String getName() {
        return "dn-crl.db";
    }

    public String getLocationConfigKey() {
        throw new UnsupportedOperationException("No location config key available for datanode databases.");
    }

    public File getDBLocation(ConfigurationSource conf) {
        String metadataDir = conf.get("hdds.metadata.dir", conf.get("ozone.metadata.dirs", conf.get("hdds.datanode.dir")));
        Preconditions.checkNotNull((Object)metadataDir, (Object)"Metadata directory can't be null. Please check configs.");
        HddsUtils.createDir((String)(metadataDir + File.separator + "dn"));
        return HddsUtils.createDir((String)(metadataDir + File.separator + "dn" + File.separator + "crl"));
    }

    public DBColumnFamilyDefinition[] getColumnFamilies() {
        return new DBColumnFamilyDefinition[]{PENDING_CRLS, CRL_SEQUENCE_ID};
    }
}

