/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli.pipeline;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.stream.Stream;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.client.ReplicationConfig;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="list", description={"List all active pipelines"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ListPipelinesSubcommand
extends ScmSubcommand {
    @CommandLine.Option(names={"-ffc", "--filterByFactor"}, description={"Filter listed pipelines by Factor(ONE/one)"}, defaultValue="")
    private String factor;
    @CommandLine.Option(names={"-fst", "--filterByState"}, description={"Filter listed pipelines by State(OPEN/CLOSE)"}, defaultValue="")
    private String state;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        Stream<Object> stream = scmClient.listPipelines().stream();
        if (!Strings.isNullOrEmpty((String)this.factor)) {
            stream = stream.filter(p -> ReplicationConfig.getLegacyFactor((ReplicationConfig)p.getReplicationConfig()).toString().compareToIgnoreCase(this.factor) == 0);
        }
        if (!Strings.isNullOrEmpty((String)this.state)) {
            stream = stream.filter(p -> p.getPipelineState().toString().compareToIgnoreCase(this.state) == 0);
        }
        stream.forEach(System.out::println);
    }
}

