/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.cli.OzoneAdmin;
import org.apache.hadoop.hdds.cli.SubcommandWithParent;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="printTopology", description={"Print a tree of the network topology as reported by SCM"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class TopologySubcommand
extends ScmSubcommand
implements SubcommandWithParent {
    private static final List<HddsProtos.NodeState> STATES = new ArrayList<HddsProtos.NodeState>();
    @CommandLine.Option(names={"-o", "--order"}, description={"Print Topology ordered by network location"})
    private boolean order;
    @CommandLine.Option(names={"-f", "--full"}, description={"Print Topology with full node infos"})
    private boolean fullInfo;
    @CommandLine.Option(names={"--operational-state"}, description={"Only show datanodes in a specific operational state (IN_SERVICE, DECOMMISSIONING, DECOMMISSIONED, ENTERING_MAINTENANCE, IN_MAINTENANCE)"})
    private String nodeOperationalState;
    @CommandLine.Option(names={"--node-state"}, description={"Only show datanodes in a specific node state( HEALTHY, STALE, DEAD)"})
    private String nodeState;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        for (HddsProtos.NodeState state : STATES) {
            List nodes = scmClient.queryNode(null, state, HddsProtos.QueryScope.CLUSTER, "");
            if (nodes == null || nodes.size() <= 0) continue;
            System.out.println("State = " + state.toString());
            if (this.nodeOperationalState != null) {
                if (this.nodeOperationalState.equals("IN_SERVICE") || this.nodeOperationalState.equals("DECOMMISSIONING") || this.nodeOperationalState.equals("DECOMMISSIONED") || this.nodeOperationalState.equals("ENTERING_MAINTENANCE") || this.nodeOperationalState.equals("IN_MAINTENANCE")) {
                    nodes = nodes.stream().filter(info -> info.getNodeOperationalStates(0).toString().equals(this.nodeOperationalState)).collect(Collectors.toList());
                } else {
                    throw new InvalidPropertiesFormatException("the nodeOperationalState isn't IN_SERVICE/DECOMMISSIONING/DECOMMISSIONED/ENTERING_MAINTENANCE/IN_MAINTENANCE the nodeOperationalState is " + this.nodeState);
                }
            }
            if (this.nodeState != null) {
                if (this.nodeState.equals("HEALTHY") || this.nodeState.equals("STALE") || this.nodeState.equals("DEAD")) {
                    nodes = nodes.stream().filter(info -> info.getNodeStates(0).toString().equals(this.nodeState)).collect(Collectors.toList());
                } else {
                    throw new InvalidPropertiesFormatException("the nodeState isn't HEALTHY/STALE/DEAD the nodeState is " + this.nodeState);
                }
            }
            if (this.order) {
                this.printOrderedByLocation(nodes);
                continue;
            }
            this.printNodesWithLocation(nodes);
        }
    }

    public Class<?> getParentType() {
        return OzoneAdmin.class;
    }

    private void printOrderedByLocation(List<HddsProtos.Node> nodes) {
        HashMap tree = new HashMap();
        HashMap<DatanodeDetails, HddsProtos.NodeOperationalState> state = new HashMap<DatanodeDetails, HddsProtos.NodeOperationalState>();
        for (HddsProtos.Node node : nodes) {
            String location2 = node.getNodeID().getNetworkLocation();
            if (location2 != null && !tree.containsKey(location2)) {
                tree.put(location2, new TreeSet());
            }
            DatanodeDetails dn = DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)node.getNodeID());
            ((TreeSet)tree.get(location2)).add(dn);
            state.put(dn, node.getNodeOperationalStates(0));
        }
        ArrayList locations = new ArrayList(tree.keySet());
        Collections.sort(locations);
        locations.forEach(location -> {
            System.out.println("Location: " + location);
            ((TreeSet)tree.get(location)).forEach(n -> System.out.println(" " + n.getIpAddress() + "(" + n.getHostName() + ") " + state.get(n)));
        });
    }

    private String formatPortOutput(List<HddsProtos.Port> ports) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ports.size(); ++i) {
            HddsProtos.Port port = ports.get(i);
            sb.append(port.getName()).append("=").append(port.getValue());
            if (i >= ports.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String getAdditionNodeOutput(HddsProtos.Node node) {
        return this.fullInfo ? node.getNodeID().getUuid() + "/" : "";
    }

    private void printNodesWithLocation(Collection<HddsProtos.Node> nodes) {
        nodes.forEach(node -> {
            System.out.print(" " + this.getAdditionNodeOutput((HddsProtos.Node)node) + node.getNodeID().getIpAddress() + "(" + node.getNodeID().getHostName() + "):" + this.formatPortOutput(node.getNodeID().getPortsList()));
            System.out.println("    " + node.getNodeOperationalStates(0) + "    " + (node.getNodeID().getNetworkLocation() != null ? node.getNodeID().getNetworkLocation() : "NA"));
        });
    }

    static {
        STATES.add(HddsProtos.NodeState.HEALTHY);
        STATES.add(HddsProtos.NodeState.STALE);
        STATES.add(HddsProtos.NodeState.DEAD);
    }
}

