/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="status", description={"Check if SCM is in safe mode"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class SafeModeCheckSubcommand
extends ScmSubcommand {
    private static final Logger LOG = LoggerFactory.getLogger(SafeModeCheckSubcommand.class);
    @CommandLine.Option(names={"--verbose"}, description={"Show detailed status of rules."})
    private boolean verbose;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        boolean execReturn = scmClient.inSafeMode();
        if (execReturn) {
            LOG.info("SCM is in safe mode.");
            if (this.verbose) {
                for (Map.Entry entry : scmClient.getSafeModeRuleStatuses().entrySet()) {
                    Pair value = (Pair)entry.getValue();
                    LOG.info("validated:{}, {}, {}", new Object[]{value.getLeft(), entry.getKey(), value.getRight()});
                }
            }
        } else {
            LOG.info("SCM is out of safe mode.");
        }
    }
}

