/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.cli;

import java.io.IOException;
import java.util.Optional;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.scm.cli.ScmSubcommand;
import org.apache.hadoop.hdds.scm.client.ScmClient;
import picocli.CommandLine;

@CommandLine.Command(name="start", description={"Start ContainerBalancer"}, mixinStandardHelpOptions=true, versionProvider=HddsVersionProvider.class)
public class ContainerBalancerStartSubcommand
extends ScmSubcommand {
    @CommandLine.Option(names={"-t", "--threshold"}, description={"Threshold target whether the cluster is balanced"})
    private Optional<Double> threshold;
    @CommandLine.Option(names={"-i", "--idleiterations"}, description={"Maximum consecutive idle iterations"})
    private Optional<Integer> idleiterations;
    @CommandLine.Option(names={"-d", "--maxDatanodesRatioToInvolvePerIteration"}, description={"The ratio of maximum number of datanodes that should be involved in balancing in one iteration to the total number of healthy, in service nodes known to container balancer."})
    private Optional<Double> maxDatanodesRatioToInvolvePerIteration;
    @CommandLine.Option(names={"-s", "--maxSizeToMovePerIterationInGB"}, description={"Maximum size to move per iteration of balancing in GB, for 10GB it should be set as 10"})
    private Optional<Long> maxSizeToMovePerIterationInGB;
    @CommandLine.Option(names={"-e", "--maxSizeEnteringTarget"}, description={"the maximum size that can enter a target datanode while balancing in GB. This is the sum of data from multiple sources."})
    private Optional<Long> maxSizeEnteringTargetInGB;
    @CommandLine.Option(names={"-l", "--maxSizeLeavingSource"}, description={"maximum size that can leave a source datanode while balancing in GB, it is the sum of data moving to multiple targets."})
    private Optional<Long> maxSizeLeavingSourceInGB;

    @Override
    public void execute(ScmClient scmClient) throws IOException {
        boolean result = scmClient.startContainerBalancer(this.threshold, this.idleiterations, this.maxDatanodesRatioToInvolvePerIteration, this.maxSizeToMovePerIterationInGB, this.maxSizeEnteringTargetInGB, this.maxSizeLeavingSourceInGB);
        if (result) {
            System.out.println("Starting ContainerBalancer Successfully.");
            return;
        }
        System.out.println("ContainerBalancer is already running, Please stop it first.");
    }
}

