/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.cli;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hdds.cli.GenericCli;
import org.apache.hadoop.hdds.cli.HddsVersionProvider;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import picocli.CommandLine;

@CommandLine.Command(name="ozone admin", hidden=true, description={"Developer tools for Ozone Admin operations"}, versionProvider=HddsVersionProvider.class, mixinStandardHelpOptions=true)
public class OzoneAdmin
extends GenericCli {
    private OzoneConfiguration ozoneConf;

    public OzoneAdmin() {
        super(OzoneAdmin.class);
    }

    @VisibleForTesting
    public OzoneAdmin(OzoneConfiguration conf) {
        super(OzoneAdmin.class);
        this.ozoneConf = conf;
    }

    public OzoneConfiguration getOzoneConf() {
        if (this.ozoneConf == null) {
            this.ozoneConf = this.createOzoneConfiguration();
        }
        return this.ozoneConf;
    }

    public static void main(String[] argv) {
        LogManager.resetConfiguration();
        Logger.getRootLogger().setLevel(Level.INFO);
        Logger.getRootLogger().addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
        Logger.getLogger(NativeCodeLoader.class).setLevel(Level.ERROR);
        new OzoneAdmin().run(argv);
    }

    public void execute(String[] argv) {
        TracingUtil.initTracing((String)"shell", (ConfigurationSource)this.createOzoneConfiguration());
        TracingUtil.executeInNewSpan((String)"main", () -> {
            super.execute(argv);
            return null;
        });
    }
}

