/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om.codec;

import com.google.common.base.Preconditions;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import org.apache.hadoop.hdds.utils.db.Codec;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;

public class TokenIdentifierCodec
implements Codec<OzoneTokenIdentifier> {
    public byte[] toPersistedFormat(OzoneTokenIdentifier object) {
        Preconditions.checkNotNull((Object)object, (Object)"Null object can't be converted to byte array.");
        return object.toUniqueSerializedKey();
    }

    public OzoneTokenIdentifier fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull((Object)rawData, (Object)"Null byte array can't converted to real object.");
        try {
            OzoneTokenIdentifier object = OzoneTokenIdentifier.newInstance();
            return object.fromUniqueSerializedKey(rawData);
        }
        catch (IOException ex) {
            try {
                return OzoneTokenIdentifier.readProtoBuf((byte[])rawData);
            }
            catch (InvalidProtocolBufferException e) {
                throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
            }
        }
        catch (BufferUnderflowException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    public OzoneTokenIdentifier copyObject(OzoneTokenIdentifier object) {
        return object;
    }
}

