/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.om;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.utils.DBStoreHAManager;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.hdds.utils.db.TableIterator;
import org.apache.hadoop.hdds.utils.db.cache.CacheKey;
import org.apache.hadoop.hdds.utils.db.cache.CacheValue;
import org.apache.hadoop.ozone.common.BlockGroup;
import org.apache.hadoop.ozone.om.helpers.BucketLayout;
import org.apache.hadoop.ozone.om.helpers.OmBucketInfo;
import org.apache.hadoop.ozone.om.helpers.OmDirectoryInfo;
import org.apache.hadoop.ozone.om.helpers.OmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmMultipartKeyInfo;
import org.apache.hadoop.ozone.om.helpers.OmPrefixInfo;
import org.apache.hadoop.ozone.om.helpers.OmVolumeArgs;
import org.apache.hadoop.ozone.om.helpers.RepeatedOmKeyInfo;
import org.apache.hadoop.ozone.om.helpers.S3SecretValue;
import org.apache.hadoop.ozone.om.lock.OzoneManagerLock;
import org.apache.hadoop.ozone.security.OzoneTokenIdentifier;
import org.apache.hadoop.ozone.storage.proto.OzoneManagerStorageProtos;

public interface OMMetadataManager
extends DBStoreHAManager {
    public void start(OzoneConfiguration var1) throws IOException;

    public void stop() throws Exception;

    @VisibleForTesting
    public DBStore getStore();

    public OzoneManagerLock getLock();

    public long getOmEpoch();

    public String getVolumeKey(String var1);

    public String getUserKey(String var1);

    public String getBucketKey(String var1, String var2);

    public String getOzoneKey(String var1, String var2, String var3);

    public String getOzoneDirKey(String var1, String var2, String var3);

    public String getOpenKey(String var1, String var2, String var3, long var4);

    public boolean isVolumeEmpty(String var1) throws IOException;

    public boolean isBucketEmpty(String var1, String var2) throws IOException;

    public List<OmBucketInfo> listBuckets(String var1, String var2, String var3, int var4) throws IOException;

    public List<OmKeyInfo> listKeys(String var1, String var2, String var3, String var4, int var5) throws IOException;

    public List<RepeatedOmKeyInfo> listTrash(String var1, String var2, String var3, String var4, int var5) throws IOException;

    public boolean recoverTrash(String var1, String var2, String var3, String var4) throws IOException;

    public List<OmVolumeArgs> listVolumes(String var1, String var2, String var3, int var4) throws IOException;

    public List<BlockGroup> getPendingDeletionKeys(int var1) throws IOException;

    public List<String> getExpiredOpenKeys(int var1) throws IOException;

    public Table<String, OzoneManagerStorageProtos.PersistedUserVolumeInfo> getUserTable();

    public Table<String, OmVolumeArgs> getVolumeTable();

    public Table<String, OmBucketInfo> getBucketTable();

    public Table<String, OmKeyInfo> getKeyTable();

    public Table<String, OmKeyInfo> getFileTable();

    public Table<String, RepeatedOmKeyInfo> getDeletedTable();

    public Table<String, OmKeyInfo> getOpenKeyTable(BucketLayout var1);

    public Table<OzoneTokenIdentifier, Long> getDelegationTokenTable();

    public Table<String, OmPrefixInfo> getPrefixTable();

    public String getMultipartKey(String var1, String var2, String var3, String var4);

    public Table<String, OmMultipartKeyInfo> getMultipartInfoTable();

    public Table<String, S3SecretValue> getS3SecretTable();

    public Table<String, TransactionInfo> getTransactionInfoTable();

    public Table<String, String> getMetaTable();

    public <KEY, VALUE> long countRowsInTable(Table<KEY, VALUE> var1) throws IOException;

    public <KEY, VALUE> long countEstimatedRowsInTable(Table<KEY, VALUE> var1) throws IOException;

    public Set<String> getMultipartUploadKeys(String var1, String var2, String var3) throws IOException;

    public Table<String, OmDirectoryInfo> getDirectoryTable();

    public Table getTable(String var1);

    public Map<String, Table> listTables();

    public Set<String> listTableNames();

    public Iterator<Map.Entry<CacheKey<String>, CacheValue<OmBucketInfo>>> getBucketIterator();

    public TableIterator<String, ? extends Table.KeyValue<String, OmKeyInfo>> getKeyIterator();

    public String getOzonePathKey(long var1, String var3);

    public String getOpenFileName(long var1, String var3, long var4);

    public String getMultipartKey(long var1, String var3, String var4);

    public Table<String, OmKeyInfo> getDeletedDirTable();
}

