/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils.db;

import java.io.File;
import java.util.Arrays;
import java.util.Optional;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DBDefinition {
    public static final Logger LOG = LoggerFactory.getLogger(DBDefinition.class);

    public String getName();

    public String getLocationConfigKey();

    default public File getDBLocation(ConfigurationSource conf) {
        return ServerUtils.getDirectoryFromConfig((ConfigurationSource)conf, (String)this.getLocationConfigKey(), (String)this.getName());
    }

    public DBColumnFamilyDefinition[] getColumnFamilies();

    default public Optional<Class> getKeyType(String table) {
        return Arrays.stream(this.getColumnFamilies()).filter(cf -> cf.getName().equals(table)).map(DBColumnFamilyDefinition::getKeyType).findAny();
    }

    default public Optional<Class> getValueType(String table) {
        return Arrays.stream(this.getColumnFamilies()).filter(cf -> cf.getName().equals(table)).map(DBColumnFamilyDefinition::getValueType).findAny();
    }
}

