/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.Interns;

public class ProtocolMessageMetrics<KEY>
implements MetricsSource {
    private String name;
    private String description;
    private Map<KEY, AtomicLong> counters = new ConcurrentHashMap<KEY, AtomicLong>();
    private Map<KEY, AtomicLong> elapsedTimes = new ConcurrentHashMap<KEY, AtomicLong>();

    public static <KEY> ProtocolMessageMetrics<KEY> create(String name, String description, KEY[] types) {
        return new ProtocolMessageMetrics<KEY>(name, description, types);
    }

    public ProtocolMessageMetrics(String name, String description, KEY[] values) {
        this.name = name;
        this.description = description;
        for (KEY value : values) {
            this.counters.put(value, new AtomicLong(0L));
            this.elapsedTimes.put(value, new AtomicLong(0L));
        }
    }

    public void increment(KEY key, long duration) {
        this.counters.get(key).incrementAndGet();
        this.elapsedTimes.get(key).addAndGet(duration);
    }

    public void register() {
        DefaultMetricsSystem.instance().register(this.name, this.description, (Object)this);
    }

    public void unregister() {
        DefaultMetricsSystem.instance().unregisterSource(this.name);
    }

    public void getMetrics(MetricsCollector collector, boolean all) {
        this.counters.forEach((key, value) -> {
            MetricsRecordBuilder builder = collector.addRecord(this.name);
            builder.add(new MetricsTag(Interns.info((String)"type", (String)"Message type"), key.toString()));
            builder.addCounter((MetricsInfo)new MetricName("counter", "Number of distinct calls"), value.longValue());
            builder.addCounter((MetricsInfo)new MetricName("time", "Sum of the duration of the calls"), this.elapsedTimes.get(key).longValue());
            builder.endRecord();
        });
    }

    public static class MetricName
    implements MetricsInfo {
        private String name;
        private String description;

        public MetricName(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String name() {
            return this.name;
        }

        public String description() {
            return this.description;
        }
    }
}

