/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hdds.StringUtils;

public final class MetadataKeyFilters {
    private MetadataKeyFilters() {
    }

    public static KeyPrefixFilter getDeletingKeyFilter() {
        return new KeyPrefixFilter().addFilter("#deleting#");
    }

    public static KeyPrefixFilter getUnprefixedKeyFilter() {
        return new KeyPrefixFilter().addFilter("#", true);
    }

    public static class KeyPrefixFilter
    implements MetadataKeyFilter {
        private List<String> positivePrefixList = new ArrayList<String>();
        private List<String> negativePrefixList = new ArrayList<String>();
        private boolean atleastOnePositiveMatch;
        private int keysScanned = 0;
        private int keysHinted = 0;

        public KeyPrefixFilter() {
        }

        public KeyPrefixFilter(boolean atleastOnePositiveMatch) {
            this.atleastOnePositiveMatch = atleastOnePositiveMatch;
        }

        public KeyPrefixFilter addFilter(String keyPrefix) {
            this.addFilter(keyPrefix, false);
            return this;
        }

        public KeyPrefixFilter addFilter(String keyPrefix, boolean negative) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)keyPrefix) ? 1 : 0) != 0, (String)"KeyPrefix is null or empty: %s", (Object)keyPrefix);
            if (negative) {
                Preconditions.checkArgument((boolean)this.positivePrefixList.stream().noneMatch(prefix -> prefix.startsWith(keyPrefix) || keyPrefix.startsWith((String)prefix)), (Object)("KeyPrefix: " + keyPrefix + " already accepted."));
                this.negativePrefixList.add(keyPrefix);
            } else {
                Preconditions.checkArgument((boolean)this.negativePrefixList.stream().noneMatch(prefix -> prefix.startsWith(keyPrefix) || keyPrefix.startsWith((String)prefix)), (Object)("KeyPrefix: " + keyPrefix + " already rejected."));
                this.positivePrefixList.add(keyPrefix);
            }
            return this;
        }

        @Override
        public boolean filterKey(byte[] preKey, byte[] currentKey, byte[] nextKey) {
            boolean accept;
            ++this.keysScanned;
            if (currentKey == null) {
                return false;
            }
            if (this.positivePrefixList.isEmpty() && this.negativePrefixList.isEmpty()) {
                return true;
            }
            boolean bl = accept = !this.positivePrefixList.isEmpty() && this.positivePrefixList.stream().anyMatch(prefix -> {
                byte[] prefixBytes = StringUtils.string2Bytes((String)prefix);
                return KeyPrefixFilter.prefixMatch(prefixBytes, currentKey);
            });
            if (accept) {
                ++this.keysHinted;
                return true;
            }
            if (this.atleastOnePositiveMatch) {
                return false;
            }
            boolean bl2 = accept = !this.negativePrefixList.isEmpty() && this.negativePrefixList.stream().allMatch(prefix -> {
                byte[] prefixBytes = StringUtils.string2Bytes((String)prefix);
                return !KeyPrefixFilter.prefixMatch(prefixBytes, currentKey);
            });
            if (accept) {
                ++this.keysHinted;
                return true;
            }
            return false;
        }

        @Override
        public int getKeysScannedNum() {
            return this.keysScanned;
        }

        @Override
        public int getKeysHintedNum() {
            return this.keysHinted;
        }

        private static boolean prefixMatch(byte[] prefix, byte[] key) {
            Preconditions.checkNotNull((Object)prefix);
            Preconditions.checkNotNull((Object)key);
            if (key.length < prefix.length) {
                return false;
            }
            for (int i = 0; i < prefix.length; ++i) {
                if (key[i] == prefix[i]) continue;
                return false;
            }
            return true;
        }
    }

    public static interface MetadataKeyFilter {
        public boolean filterKey(byte[] var1, byte[] var2, byte[] var3);

        default public int getKeysScannedNum() {
            return 0;
        }

        default public int getKeysHintedNum() {
            return 0;
        }
    }
}

