/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.protobuf.BlockingService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.HddsUtils;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.protocol.SCMSecurityProtocol;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.ratis.ServerNotLeaderException;
import org.apache.hadoop.hdds.scm.proxy.SCMClientConfig;
import org.apache.hadoop.hdds.scm.proxy.SCMSecurityProtocolFailoverProxyProvider;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.db.DBCheckpoint;
import org.apache.hadoop.ipc.ProtobufRpcEngine;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.source.JvmMetrics;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HddsServerUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HddsServerUtil.class);

    private HddsServerUtil() {
    }

    public static void addPBProtocol(Configuration conf, Class<?> protocol, BlockingService service, RPC.Server server) throws IOException {
        RPC.setProtocolEngine((Configuration)conf, protocol, ProtobufRpcEngine.class);
        server.addProtocol(RPC.RpcKind.RPC_PROTOCOL_BUFFER, protocol, (Object)service);
    }

    public static InetSocketAddress getScmClientBindAddress(ConfigurationSource conf) {
        String host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.client.bind.host"}).orElse("0.0.0.0");
        int port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.client.address"}).orElse(conf.getInt("ozone.scm.client.port", 9860));
        return NetUtils.createSocketAddr((String)(host + ":" + port));
    }

    public static InetSocketAddress getScmBlockClientBindAddress(ConfigurationSource conf) {
        String host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.block.client.bind.host"}).orElse("0.0.0.0");
        int port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.block.client.address"}).orElse(conf.getInt("ozone.scm.block.client.port", 9863));
        return NetUtils.createSocketAddr((String)(host + ":" + port));
    }

    public static InetSocketAddress getScmSecurityInetAddress(ConfigurationSource conf) {
        String host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.security.service.bind.host"}).orElse("0.0.0.0");
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.security.service.address"});
        return NetUtils.createSocketAddr((String)(host + ":" + port.orElse(conf.getInt("ozone.scm.security.service.port", 9961))));
    }

    public static InetSocketAddress getScmDataNodeBindAddress(ConfigurationSource conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.datanode.bind.host"});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.scm.datanode.address"});
        return NetUtils.createSocketAddr((String)(host.orElse("0.0.0.0") + ":" + port.orElse(conf.getInt("ozone.scm.datanode.port", 9861))));
    }

    public static InetSocketAddress getReconDataNodeBindAddress(ConfigurationSource conf) {
        Optional host = HddsUtils.getHostNameFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.recon.datanode.bind.host"});
        OptionalInt port = HddsUtils.getPortNumberFromConfigKeys((ConfigurationSource)conf, (String[])new String[]{"ozone.recon.datanode.address"});
        return NetUtils.createSocketAddr((String)(host.orElse("0.0.0.0") + ":" + port.orElse(9891)));
    }

    public static long getScmheartbeatCheckerInterval(ConfigurationSource conf) {
        return conf.getTimeDuration("ozone.scm.heartbeat.thread.interval", "3s", TimeUnit.MILLISECONDS);
    }

    public static long getScmHeartbeatInterval(ConfigurationSource conf) {
        return conf.getTimeDuration("hdds.heartbeat.interval", "30s", TimeUnit.MILLISECONDS);
    }

    public static long getStaleNodeInterval(ConfigurationSource conf) {
        long staleNodeIntervalMs = conf.getTimeDuration("ozone.scm.stale.node.interval", "5m", TimeUnit.MILLISECONDS);
        long heartbeatThreadFrequencyMs = HddsServerUtil.getScmheartbeatCheckerInterval(conf);
        long heartbeatIntervalMs = HddsServerUtil.getScmHeartbeatInterval(conf);
        staleNodeIntervalMs = ServerUtils.sanitizeUserArgs((String)"ozone.scm.stale.node.interval", (long)staleNodeIntervalMs, (String)"ozone.scm.heartbeat.thread.interval", (long)heartbeatThreadFrequencyMs, (long)5L, (long)1000L);
        staleNodeIntervalMs = ServerUtils.sanitizeUserArgs((String)"ozone.scm.stale.node.interval", (long)staleNodeIntervalMs, (String)"hdds.heartbeat.interval", (long)heartbeatIntervalMs, (long)3L, (long)1000L);
        return staleNodeIntervalMs;
    }

    public static long getDeadNodeInterval(ConfigurationSource conf) {
        long staleNodeIntervalMs = HddsServerUtil.getStaleNodeInterval(conf);
        long deadNodeIntervalMs = conf.getTimeDuration("ozone.scm.dead.node.interval", "10m", TimeUnit.MILLISECONDS);
        return ServerUtils.sanitizeUserArgs((String)"ozone.scm.dead.node.interval", (long)deadNodeIntervalMs, (String)"ozone.scm.stale.node.interval", (long)staleNodeIntervalMs, (long)2L, (long)1000L);
    }

    public static long getScmRpcTimeOutInMilliseconds(ConfigurationSource conf) {
        return conf.getTimeDuration("ozone.scm.heartbeat.rpc-timeout", "5s", TimeUnit.MILLISECONDS);
    }

    public static int getScmRpcRetryCount(ConfigurationSource conf) {
        return conf.getInt("ozone.scm.heartbeat.rpc-retry-count", 15);
    }

    public static long getScmRpcRetryInterval(ConfigurationSource conf) {
        return conf.getTimeDuration("ozone.scm.heartbeat.rpc-retry-interval", "1s", TimeUnit.MILLISECONDS);
    }

    public static int getLogWarnInterval(ConfigurationSource conf) {
        return conf.getInt("ozone.scm.heartbeat.log.warn.interval.count", 10);
    }

    public static int getContainerPort(ConfigurationSource conf) {
        return conf.getInt("dfs.container.ipc", 9859);
    }

    public static Collection<String> getOzoneDatanodeRatisDirectory(ConfigurationSource conf) {
        ArrayList<String> rawLocations = conf.getTrimmedStringCollection("dfs.container.ratis.datanode.storage.dir");
        if (rawLocations.isEmpty()) {
            rawLocations = new ArrayList<String>(1);
            rawLocations.add(ServerUtils.getDefaultRatisDirectory((ConfigurationSource)conf));
        }
        return rawLocations;
    }

    public static Collection<String> getDatanodeStorageDirs(ConfigurationSource conf) {
        Collection rawLocations = conf.getTrimmedStringCollection("hdds.datanode.dir");
        if (rawLocations.isEmpty()) {
            rawLocations = conf.getTrimmedStringCollection("dfs.datanode.data.dir");
        }
        if (rawLocations.isEmpty()) {
            throw new IllegalArgumentException("No location configured in either hdds.datanode.dir or dfs.datanode.data.dir");
        }
        return rawLocations;
    }

    public static String getDatanodeIdFilePath(ConfigurationSource conf) {
        String dataNodeIDDirPath = conf.get("ozone.scm.datanode.id.dir");
        if (dataNodeIDDirPath == null) {
            File metaDirPath = ServerUtils.getOzoneMetaDirPath((ConfigurationSource)conf);
            if (metaDirPath == null) {
                throw new IllegalArgumentException("Unable to locate meta datadirectory when getting datanode id path");
            }
            dataNodeIDDirPath = metaDirPath.toString();
        }
        return new File(dataNodeIDDirPath, "datanode.id").toString();
    }

    public static SCMSecurityProtocolClientSideTranslatorPB getScmSecurityClient(ConfigurationSource conf) throws IOException {
        return new SCMSecurityProtocolClientSideTranslatorPB(new SCMSecurityProtocolFailoverProxyProvider(conf, UserGroupInformation.getCurrentUser()));
    }

    public static SCMSecurityProtocolClientSideTranslatorPB getScmSecurityClientWithMaxRetry(OzoneConfiguration conf) throws IOException {
        OzoneConfiguration configuration = new OzoneConfiguration((Configuration)conf);
        SCMClientConfig scmClientConfig = (SCMClientConfig)conf.getObject(SCMClientConfig.class);
        int retryCount = Integer.MAX_VALUE;
        scmClientConfig.setRetryCount(retryCount);
        configuration.setFromObject((Object)scmClientConfig);
        return new SCMSecurityProtocolClientSideTranslatorPB(new SCMSecurityProtocolFailoverProxyProvider((ConfigurationSource)configuration, UserGroupInformation.getCurrentUser()));
    }

    public static SCMSecurityProtocolClientSideTranslatorPB getScmSecurityClientWithFixedDuration(OzoneConfiguration conf) throws IOException {
        SCMClientConfig scmClientConfig;
        OzoneConfiguration configuration = new OzoneConfiguration((Configuration)conf);
        long duration = conf.getTimeDuration("ozone.scm.info.wait.duration", 600L, TimeUnit.SECONDS);
        int retryCount = (int)(duration / ((scmClientConfig = (SCMClientConfig)conf.getObject(SCMClientConfig.class)).getRetryInterval() / 1000L));
        if (retryCount > scmClientConfig.getRetryCount()) {
            scmClientConfig.setRetryCount(retryCount);
            configuration.setFromObject((Object)scmClientConfig);
        }
        return new SCMSecurityProtocolClientSideTranslatorPB(new SCMSecurityProtocolFailoverProxyProvider((ConfigurationSource)configuration, UserGroupInformation.getCurrentUser()));
    }

    public static SCMSecurityProtocol getScmSecurityClient(OzoneConfiguration conf, UserGroupInformation ugi) throws IOException {
        SCMSecurityProtocolClientSideTranslatorPB scmSecurityClient = new SCMSecurityProtocolClientSideTranslatorPB(new SCMSecurityProtocolFailoverProxyProvider((ConfigurationSource)conf, ugi));
        return (SCMSecurityProtocol)TracingUtil.createProxy((Object)scmSecurityClient, SCMSecurityProtocol.class, (ConfigurationSource)conf);
    }

    public static MetricsSystem initializeMetrics(OzoneConfiguration configuration, String serverName) {
        MetricsSystem metricsSystem = DefaultMetricsSystem.initialize((String)serverName);
        try {
            JvmMetrics.create((String)serverName, (String)configuration.get("dfs.metrics.session-id"), (MetricsSystem)DefaultMetricsSystem.instance());
        }
        catch (MetricsException e) {
            LOG.info("Metrics source JvmMetrics already added to DataNode.");
        }
        return metricsSystem;
    }

    public static void writeDBCheckpointToStream(DBCheckpoint checkpoint, OutputStream destination) throws IOException {
        try (CompressorOutputStream gzippedOut = new CompressorStreamFactory().createCompressorOutputStream("gz", destination);
             TarArchiveOutputStream archiveOutputStream = new TarArchiveOutputStream((OutputStream)gzippedOut);
             Stream<Path> files = Files.list(checkpoint.getCheckpointLocation());){
            for (Path path : files.collect(Collectors.toList())) {
                Path fileName;
                if (path == null || (fileName = path.getFileName()) == null) continue;
                HddsServerUtil.includeFile(path.toFile(), fileName.toString(), (ArchiveOutputStream)archiveOutputStream);
            }
        }
        catch (CompressorException e) {
            throw new IOException("Can't compress the checkpoint: " + checkpoint.getCheckpointLocation(), e);
        }
    }

    private static void includeFile(File file, String entryName, ArchiveOutputStream archiveOutputStream) throws IOException {
        ArchiveEntry archiveEntry = archiveOutputStream.createArchiveEntry(file, entryName);
        archiveOutputStream.putArchiveEntry(archiveEntry);
        try (FileInputStream fis = new FileInputStream(file);){
            IOUtils.copy((InputStream)fis, (OutputStream)archiveOutputStream);
        }
        archiveOutputStream.closeArchiveEntry();
    }

    public static IOException toIOException(String msg, RocksDBException e) {
        String statusCode = e.getStatus() == null ? "N/A" : e.getStatus().getCodeString();
        String errMessage = e.getMessage() == null ? "Unknown error" : e.getMessage();
        String output = msg + "; status : " + statusCode + "; message : " + errMessage;
        return new IOException(output, e);
    }

    public static void addSuppressedLoggingExceptions(RPC.Server server) {
        server.addSuppressedLoggingExceptions(new Class[]{ServerNotLeaderException.class});
    }
}

