/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.conf.OzoneConfiguration;
import org.apache.hadoop.hdds.function.SupplierWithIOException;
import org.apache.hadoop.hdds.protocol.proto.SCMSecurityProtocolProtos;
import org.apache.hadoop.hdds.protocolPB.SCMSecurityProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.AddSCMRequest;
import org.apache.hadoop.hdds.scm.ScmInfo;
import org.apache.hadoop.hdds.scm.ha.SCMHAUtils;
import org.apache.hadoop.hdds.scm.protocol.ScmBlockLocationProtocol;
import org.apache.hadoop.hdds.scm.protocol.StorageContainerLocationProtocol;
import org.apache.hadoop.hdds.scm.protocolPB.ScmBlockLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.protocolPB.StorageContainerLocationProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdds.scm.proxy.SCMBlockLocationFailoverProxyProvider;
import org.apache.hadoop.hdds.scm.proxy.SCMClientConfig;
import org.apache.hadoop.hdds.scm.proxy.SCMContainerLocationFailoverProxyProvider;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.apache.hadoop.hdds.server.ServerUtils;
import org.apache.hadoop.hdds.tracing.TracingUtil;
import org.apache.hadoop.hdds.utils.HddsServerUtil;
import org.apache.hadoop.hdds.utils.RetriableTask;
import org.apache.hadoop.hdds.utils.TransactionInfo;
import org.apache.hadoop.hdds.utils.db.DBColumnFamilyDefinition;
import org.apache.hadoop.hdds.utils.db.DBDefinition;
import org.apache.hadoop.hdds.utils.db.DBStore;
import org.apache.hadoop.hdds.utils.db.DBStoreBuilder;
import org.apache.hadoop.hdds.utils.db.RocksDBConfiguration;
import org.apache.hadoop.hdds.utils.db.Table;
import org.apache.hadoop.io.retry.RetryPolicies;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.ozone.OzoneSecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ratis.util.ExitUtils;
import org.apache.ratis.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HAUtils {
    public static final Logger LOG = LoggerFactory.getLogger(HAUtils.class);

    private HAUtils() {
    }

    public static ScmInfo getScmInfo(OzoneConfiguration conf) throws IOException {
        OzoneConfiguration configuration = new OzoneConfiguration((Configuration)conf);
        try {
            long duration = conf.getTimeDuration("ozone.scm.info.wait.duration", 600L, TimeUnit.SECONDS);
            SCMClientConfig scmClientConfig = (SCMClientConfig)configuration.getObject(SCMClientConfig.class);
            int retryCount = (int)(duration / (scmClientConfig.getRetryInterval() / 1000L));
            if (retryCount > scmClientConfig.getRetryCount()) {
                scmClientConfig.setRetryCount(retryCount);
                configuration.setFromObject((Object)scmClientConfig);
            }
            return HAUtils.getScmBlockClient(configuration).getScmInfo();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to get SCM info", e);
        }
    }

    public static boolean addSCM(OzoneConfiguration conf, AddSCMRequest request, String selfId) throws IOException {
        OzoneConfiguration config = SCMHAUtils.removeSelfId((OzoneConfiguration)conf, (String)selfId);
        try {
            return HAUtils.getScmBlockClient(config).addSCM(request);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to add SCM", e);
        }
    }

    public static ScmBlockLocationProtocol getScmBlockClient(OzoneConfiguration conf) {
        ScmBlockLocationProtocolClientSideTranslatorPB scmBlockLocationClient = new ScmBlockLocationProtocolClientSideTranslatorPB(new SCMBlockLocationFailoverProxyProvider((ConfigurationSource)conf));
        return (ScmBlockLocationProtocol)TracingUtil.createProxy((Object)scmBlockLocationClient, ScmBlockLocationProtocol.class, (ConfigurationSource)conf);
    }

    public static StorageContainerLocationProtocol getScmContainerClient(ConfigurationSource conf) {
        SCMContainerLocationFailoverProxyProvider proxyProvider = new SCMContainerLocationFailoverProxyProvider(conf, null);
        StorageContainerLocationProtocol scmContainerClient = (StorageContainerLocationProtocol)TracingUtil.createProxy((Object)new StorageContainerLocationProtocolClientSideTranslatorPB(proxyProvider), StorageContainerLocationProtocol.class, (ConfigurationSource)conf);
        return scmContainerClient;
    }

    @VisibleForTesting
    public static StorageContainerLocationProtocol getScmContainerClient(ConfigurationSource conf, UserGroupInformation userGroupInformation) {
        SCMContainerLocationFailoverProxyProvider proxyProvider = new SCMContainerLocationFailoverProxyProvider(conf, userGroupInformation);
        StorageContainerLocationProtocol scmContainerClient = (StorageContainerLocationProtocol)TracingUtil.createProxy((Object)new StorageContainerLocationProtocolClientSideTranslatorPB(proxyProvider), StorageContainerLocationProtocol.class, (ConfigurationSource)conf);
        return scmContainerClient;
    }

    public static File replaceDBWithCheckpoint(long lastAppliedIndex, File oldDB, Path checkpointPath, String dbPrefix) throws IOException {
        String dbBackupName = dbPrefix + lastAppliedIndex + "_" + System.currentTimeMillis();
        File dbDir = oldDB.getParentFile();
        File dbBackup = new File(dbDir, dbBackupName);
        try {
            Files.move(oldDB.toPath(), dbBackup.toPath(), new CopyOption[0]);
        }
        catch (IOException e) {
            LOG.error("Failed to create a backup of the current DB. Aborting snapshot installation.");
            throw e;
        }
        Path markerFile = new File(dbDir, "dbInconsistentMarker").toPath();
        try {
            Files.createFile(markerFile, new FileAttribute[0]);
            Files.move(checkpointPath, oldDB.toPath(), new CopyOption[0]);
            Files.deleteIfExists(markerFile);
        }
        catch (IOException e) {
            LOG.error("Failed to move downloaded DB checkpoint {} to metadata directory {}. Resetting to original DB.", (Object)checkpointPath, (Object)oldDB.toPath());
            try {
                Files.move(dbBackup.toPath(), oldDB.toPath(), new CopyOption[0]);
                Files.deleteIfExists(markerFile);
            }
            catch (IOException ex) {
                String errorMsg = "Failed to reset to original DB. SCM is in an inconsistent state.";
                ExitUtils.terminate((int)1, (String)errorMsg, (Throwable)ex, (Logger)LOG);
            }
            throw e;
        }
        return dbBackup;
    }

    public static TransactionInfo getTrxnInfoFromCheckpoint(OzoneConfiguration conf, Path dbPath, DBDefinition definition) throws Exception {
        if (dbPath != null) {
            Path dbDir = dbPath.getParent();
            Path dbFile = dbPath.getFileName();
            if (dbDir != null && dbFile != null) {
                return HAUtils.getTransactionInfoFromDB(conf, dbDir, dbFile.toString(), definition);
            }
        }
        throw new IOException("Checkpoint " + dbPath + " does not have proper DB location");
    }

    private static TransactionInfo getTransactionInfoFromDB(OzoneConfiguration tempConfig, Path dbDir, String dbName, DBDefinition definition) throws Exception {
        DBStore dbStore = HAUtils.loadDB(tempConfig, dbDir.toFile(), dbName, definition);
        Table<String, TransactionInfo> transactionInfoTable = HAUtils.getTransactionInfoTable(dbStore, definition);
        TransactionInfo transactionInfo = transactionInfoTable.get("#TRANSACTIONINFO");
        dbStore.close();
        if (transactionInfo == null) {
            throw new IOException("Failed to read TransactionInfo from DB " + definition.getName() + " at " + dbDir);
        }
        return transactionInfo;
    }

    public static Table<String, TransactionInfo> getTransactionInfoTable(DBStore dbStore, DBDefinition definition) throws IOException {
        return Arrays.stream(definition.getColumnFamilies()).filter(t -> t.getValueType() == TransactionInfo.class).findFirst().get().getTable(dbStore);
    }

    public static boolean verifyTransactionInfo(TransactionInfo transactionInfo, long lastAppliedIndex, String leaderId, Path newDBlocation, Logger logger) {
        if (transactionInfo.getTransactionIndex() <= lastAppliedIndex) {
            logger.error("Failed to install checkpoint from SCM leader: {}. The last applied index: {} is greater than or equal to the checkpoint's applied index: {}. Deleting the downloaded checkpoint {}", new Object[]{leaderId, lastAppliedIndex, transactionInfo.getTransactionIndex(), newDBlocation});
            try {
                FileUtils.deleteFully((Path)newDBlocation);
            }
            catch (IOException e) {
                logger.error("Failed to fully delete the downloaded DB checkpoint {} from SCM leader {}.", new Object[]{newDBlocation, leaderId, e});
            }
            return false;
        }
        return true;
    }

    public static DBStore loadDB(OzoneConfiguration configuration, File metaDir, String dbName, DBDefinition definition) throws IOException {
        RocksDBConfiguration rocksDBConfiguration = (RocksDBConfiguration)configuration.getObject(RocksDBConfiguration.class);
        DBStoreBuilder dbStoreBuilder = DBStoreBuilder.newBuilder((ConfigurationSource)configuration, rocksDBConfiguration).setName(dbName).setPath(Paths.get(metaDir.getPath(), new String[0]));
        for (DBColumnFamilyDefinition columnFamily : definition.getColumnFamilies()) {
            dbStoreBuilder.addTable(columnFamily.getName());
            dbStoreBuilder.addCodec(columnFamily.getKeyType(), columnFamily.getKeyCodec());
            dbStoreBuilder.addCodec(columnFamily.getValueType(), columnFamily.getValueCodec());
        }
        return dbStoreBuilder.build();
    }

    public static File getMetaDir(DBDefinition definition, OzoneConfiguration configuration) {
        File metadataDir = definition.getDBLocation((ConfigurationSource)configuration);
        if (metadataDir == null) {
            LOG.warn("{} is not configured. We recommend adding this setting. Falling back to {} instead.", (Object)definition.getLocationConfigKey(), (Object)"ozone.metadata.dirs");
            metadataDir = ServerUtils.getOzoneMetaDirPath((ConfigurationSource)configuration);
        }
        return metadataDir;
    }

    public static List<String> buildCAList(CertificateClient certClient, ConfigurationSource configuration) throws IOException {
        long waitDuration = configuration.getTimeDuration("ozone.scm.ca.list.retry.interval", 10L, TimeUnit.SECONDS);
        if (certClient != null) {
            if (!SCMHAUtils.isSCMHAEnabled((ConfigurationSource)configuration)) {
                return HAUtils.generateCAList(certClient);
            }
            Collection scmNodes = SCMHAUtils.getSCMNodeIds((ConfigurationSource)configuration);
            int expectedCount = scmNodes.size() + 1;
            if (scmNodes.size() > 1) {
                List<String> caCertPemList = certClient.getCAList();
                if (caCertPemList != null && caCertPemList.size() == expectedCount) {
                    return caCertPemList;
                }
                return HAUtils.getCAListWithRetry(() -> HAUtils.waitForCACerts((SupplierWithIOException<List<String>>)((SupplierWithIOException)certClient::updateCAList), expectedCount), waitDuration);
            }
            return HAUtils.generateCAList(certClient);
        }
        SCMSecurityProtocolClientSideTranslatorPB scmSecurityProtocolClient = HddsServerUtil.getScmSecurityClient(configuration);
        if (!SCMHAUtils.isSCMHAEnabled((ConfigurationSource)configuration)) {
            ArrayList<String> caCertPemList = new ArrayList<String>();
            SCMSecurityProtocolProtos.SCMGetCertResponseProto scmGetCertResponseProto = scmSecurityProtocolClient.getCACert();
            if (scmGetCertResponseProto.hasX509Certificate()) {
                caCertPemList.add(scmGetCertResponseProto.getX509Certificate());
            }
            if (scmGetCertResponseProto.hasX509RootCACertificate()) {
                caCertPemList.add(scmGetCertResponseProto.getX509RootCACertificate());
            }
            return caCertPemList;
        }
        Collection scmNodes = SCMHAUtils.getSCMNodeIds((ConfigurationSource)configuration);
        int expectedCount = scmNodes.size() + 1;
        if (scmNodes.size() > 1) {
            return HAUtils.getCAListWithRetry(() -> HAUtils.waitForCACerts((SupplierWithIOException<List<String>>)((SupplierWithIOException)scmSecurityProtocolClient::listCACertificate), expectedCount), waitDuration);
        }
        return scmSecurityProtocolClient.listCACertificate();
    }

    private static List<String> generateCAList(CertificateClient certClient) throws IOException {
        ArrayList<String> caCertPemList = new ArrayList<String>();
        if (certClient.getRootCACertificate() != null) {
            caCertPemList.add(CertificateCodec.getPEMEncodedString((X509Certificate)certClient.getRootCACertificate()));
        }
        if (certClient.getCACertificate() != null) {
            caCertPemList.add(CertificateCodec.getPEMEncodedString((X509Certificate)certClient.getCACertificate()));
        }
        return caCertPemList;
    }

    private static List<String> getCAListWithRetry(Callable<List<String>> task, long waitDuration) throws IOException {
        RetryPolicy retryPolicy = RetryPolicies.retryForeverWithFixedSleep((long)waitDuration, (TimeUnit)TimeUnit.SECONDS);
        RetriableTask retriableTask = new RetriableTask(retryPolicy, "getCAList", task);
        try {
            return (List)retriableTask.call();
        }
        catch (Exception ex) {
            throw new SCMSecurityException("Unable to obtain complete CA list", (Throwable)ex);
        }
    }

    private static List<String> waitForCACerts(SupplierWithIOException<List<String>> applyFunction, int expectedCount) throws IOException {
        boolean caListUpToDate;
        List caCertPemList = (List)applyFunction.get();
        boolean bl = caListUpToDate = caCertPemList.size() == expectedCount;
        if (!caListUpToDate) {
            LOG.info("Expected CA list size {}, where as received CA List size {}.", (Object)expectedCount, (Object)caCertPemList.size());
            throw new SCMSecurityException("Expected CA list size " + expectedCount + " is not matching actual count " + caCertPemList.size());
        }
        return caCertPemList;
    }

    public static List<X509Certificate> buildCAX509List(CertificateClient certClient, ConfigurationSource conf) throws IOException {
        if (certClient != null && !SCMHAUtils.isSCMHAEnabled((ConfigurationSource)conf)) {
            ArrayList<X509Certificate> x509Certificates = new ArrayList<X509Certificate>();
            if (certClient.getRootCACertificate() != null) {
                x509Certificates.add(certClient.getRootCACertificate());
            }
            x509Certificates.add(certClient.getCACertificate());
            return x509Certificates;
        }
        List<String> pemEncodedCerts = HAUtils.buildCAList(certClient, conf);
        return OzoneSecurityUtil.convertToX509(pemEncodedCerts);
    }
}

