/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.utils;

import com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;

@InterfaceAudience.Private
@Metrics(about="DB checkpoint Metrics", context="dfs")
public class DBCheckpointMetrics {
    private static final String SOURCE_NAME = DBCheckpointMetrics.class.getSimpleName();
    @Metric
    private MutableGaugeLong lastCheckpointCreationTimeTaken;
    @Metric
    private MutableGaugeLong lastCheckpointStreamingTimeTaken;
    @Metric
    private MutableCounterLong numCheckpoints;
    @Metric
    private MutableCounterLong numCheckpointFails;

    public static DBCheckpointMetrics create(String parent) {
        MetricsSystem ms = DefaultMetricsSystem.instance();
        return (DBCheckpointMetrics)ms.register(SOURCE_NAME, parent, (Object)new DBCheckpointMetrics());
    }

    @VisibleForTesting
    public void setLastCheckpointCreationTimeTaken(long val) {
        this.lastCheckpointCreationTimeTaken.set(val);
    }

    @VisibleForTesting
    public void setLastCheckpointStreamingTimeTaken(long val) {
        this.lastCheckpointStreamingTimeTaken.set(val);
    }

    @VisibleForTesting
    public void incNumCheckpoints() {
        this.numCheckpoints.incr();
    }

    @VisibleForTesting
    public void incNumCheckpointFails() {
        this.numCheckpointFails.incr();
    }

    @VisibleForTesting
    public long getLastCheckpointCreationTimeTaken() {
        return this.lastCheckpointCreationTimeTaken.value();
    }

    @VisibleForTesting
    public long getNumCheckpoints() {
        return this.numCheckpoints.value();
    }

    @VisibleForTesting
    public long getNumCheckpointFails() {
        return this.numCheckpointFails.value();
    }

    @VisibleForTesting
    public long getLastCheckpointStreamingTimeTaken() {
        return this.lastCheckpointStreamingTimeTaken.value();
    }
}

