/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.http;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.commons.configuration2.SubsetConfiguration;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.metrics2.AbstractMetric;
import org.apache.hadoop.metrics2.MetricType;
import org.apache.hadoop.metrics2.MetricsRecord;
import org.apache.hadoop.metrics2.MetricsSink;
import org.apache.hadoop.metrics2.MetricsTag;

public class PrometheusMetricsSink
implements MetricsSink {
    private final Map<String, Map<String, String>> metricLines = Collections.synchronizedSortedMap(new TreeMap());
    private static final Pattern SPLIT_PATTERN = Pattern.compile("(?<!(^|[A-Z_]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])");
    private static final Pattern REPLACE_PATTERN = Pattern.compile("[^a-zA-Z0-9]+");

    public void putMetrics(MetricsRecord metricsRecord) {
        for (AbstractMetric metrics : metricsRecord.metrics()) {
            if (metrics.type() != MetricType.COUNTER && metrics.type() != MetricType.GAUGE) continue;
            String key = this.prometheusName(metricsRecord.name(), metrics.name());
            String prometheusMetricKeyAsString = this.getPrometheusMetricKeyAsString(metricsRecord, key);
            String metricKey = "# TYPE " + key + " " + metrics.type().toString().toLowerCase();
            this.metricLines.computeIfAbsent(metricKey, any -> Collections.synchronizedSortedMap(new TreeMap())).put(prometheusMetricKeyAsString, String.valueOf(metrics.value()));
        }
    }

    private String getPrometheusMetricKeyAsString(MetricsRecord metricsRecord, String key) {
        StringBuilder prometheusMetricKey = new StringBuilder();
        prometheusMetricKey.append(key).append("{");
        String sep = "";
        for (MetricsTag tag : metricsRecord.tags()) {
            String tagName = tag.name().toLowerCase();
            if (tagName.equals("numopenconnectionsperuser")) continue;
            prometheusMetricKey.append(sep).append(tagName).append("=\"").append(tag.value()).append("\"");
            sep = ",";
        }
        prometheusMetricKey.append("}");
        return prometheusMetricKey.toString();
    }

    public String prometheusName(String recordName, String metricName) {
        if (StringUtils.isNotEmpty((CharSequence)recordName) && recordName.startsWith("Rocksdb_")) {
            return PrometheusMetricsSink.normalizeName(recordName) + "_" + metricName.toLowerCase();
        }
        String baseName = StringUtils.capitalize((String)recordName) + StringUtils.capitalize((String)metricName);
        return PrometheusMetricsSink.normalizeName(baseName);
    }

    public static String normalizeName(String baseName) {
        CharSequence[] parts = SPLIT_PATTERN.split(baseName);
        String result = String.join((CharSequence)"_", parts).toLowerCase();
        return REPLACE_PATTERN.matcher(result).replaceAll("_");
    }

    public void flush() {
    }

    public void init(SubsetConfiguration subsetConfiguration) {
    }

    public void writeMetrics(Writer writer) throws IOException {
        for (Map.Entry<String, Map<String, String>> metricsEntry : this.metricLines.entrySet()) {
            writer.write(metricsEntry.getKey() + "\n");
            for (Map.Entry<String, String> metrics : metricsEntry.getValue().entrySet()) {
                writer.write(metrics.getKey() + " " + metrics.getValue() + "\n");
            }
        }
    }
}

