/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.server.events;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.hdds.server.events.EventExecutor;
import org.apache.hadoop.hdds.server.events.EventHandler;
import org.apache.hadoop.hdds.server.events.EventPublisher;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metrics(context="EventQueue")
public class SingleThreadExecutor<P>
implements EventExecutor<P> {
    private static final String EVENT_QUEUE = "EventQueue";
    private static final Logger LOG = LoggerFactory.getLogger(SingleThreadExecutor.class);
    private final String name;
    private final ExecutorService executor;
    @Metric
    private MutableCounterLong queued;
    @Metric
    private MutableCounterLong done;
    @Metric
    private MutableCounterLong failed;
    @Metric
    private MutableCounterLong scheduled;

    public SingleThreadExecutor(String name) {
        this.name = name;
        DefaultMetricsSystem.instance().register(EVENT_QUEUE + name, "Event Executor metrics ", (Object)this);
        this.executor = Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setName("EventQueue-" + name);
            return thread;
        });
    }

    @Override
    public void onMessage(EventHandler<P> handler, P message, EventPublisher publisher) {
        this.queued.incr();
        this.executor.execute(() -> {
            this.scheduled.incr();
            try {
                handler.onMessage(message, publisher);
                this.done.incr();
            }
            catch (Exception ex) {
                LOG.error("Error on execution message {}", message, (Object)ex);
                this.failed.incr();
            }
        });
    }

    @Override
    public long failedEvents() {
        return this.failed.value();
    }

    @Override
    public long successfulEvents() {
        return this.done.value();
    }

    @Override
    public long queuedEvents() {
        return this.queued.value();
    }

    @Override
    public long scheduledEvents() {
        return this.scheduled.value();
    }

    @Override
    public void close() {
        this.executor.shutdown();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

