/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.crl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.hadoop.hdds.utils.db.Codec;

public class CRLInfoCodec
implements Codec<CRLInfo> {
    public byte[] toPersistedFormat(CRLInfo crlInfo) throws IOException {
        return crlInfo.getProtobuf().toByteArray();
    }

    public CRLInfo fromPersistedFormat(byte[] rawData) throws IOException {
        Preconditions.checkNotNull((Object)rawData, (Object)"Null byte array can't be converted to real object.");
        try {
            return CRLInfo.fromProtobuf((HddsProtos.CRLInfoProto)HddsProtos.CRLInfoProto.PARSER.parseFrom(rawData));
        }
        catch (CRLException | CertificateException e) {
            throw new IllegalArgumentException("Can't encode the the raw data from the byte array", e);
        }
    }

    public CRLInfo copyObject(CRLInfo object) {
        throw new UnsupportedOperationException();
    }
}

