/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.crl;

import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.time.Instant;
import java.util.Comparator;
import java.util.Objects;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.scm.proto.SCMUpdateServiceProtos;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.crl.CRLCodec;
import org.jetbrains.annotations.NotNull;

public class CRLInfo
implements Comparator<CRLInfo>,
Comparable<CRLInfo> {
    private X509CRL x509CRL;
    private long creationTimestamp;
    private long crlSequenceID;
    private Instant revocationTime;

    private CRLInfo(X509CRL x509CRL, long creationTimestamp, long crlSequenceID) {
        assert (x509CRL != null && !x509CRL.getRevokedCertificates().isEmpty());
        this.x509CRL = x509CRL;
        this.creationTimestamp = creationTimestamp;
        this.crlSequenceID = crlSequenceID;
        X509CRLEntry entry = x509CRL.getRevokedCertificates().iterator().next();
        this.revocationTime = Instant.ofEpochMilli(entry.getRevocationDate().getTime());
    }

    public CRLInfo() {
    }

    public static CRLInfo fromProtobuf(HddsProtos.CRLInfoProto info) throws IOException, CRLException, CertificateException {
        Builder builder = new Builder();
        return builder.setX509CRL(CRLCodec.getX509CRL(info.getX509CRL())).setCreationTimestamp(info.getCreationTimestamp()).setCrlSequenceID(info.getCrlSequenceID()).build();
    }

    public HddsProtos.CRLInfoProto getProtobuf() throws SCMSecurityException {
        HddsProtos.CRLInfoProto.Builder builder = HddsProtos.CRLInfoProto.newBuilder();
        return builder.setX509CRL(CRLCodec.getPEMEncodedString(this.getX509CRL())).setCreationTimestamp(this.getCreationTimestamp()).setCrlSequenceID(this.getCrlSequenceID()).build();
    }

    public static CRLInfo fromCRLProto3(SCMUpdateServiceProtos.CRLInfoProto info) throws IOException, CRLException, CertificateException {
        Builder builder = new Builder();
        return builder.setX509CRL(CRLCodec.getX509CRL(info.getX509CRL())).setCreationTimestamp(info.getCreationTimestamp()).setCrlSequenceID(info.getCrlSequenceID()).build();
    }

    public SCMUpdateServiceProtos.CRLInfoProto getCRLProto3() throws SCMSecurityException {
        SCMUpdateServiceProtos.CRLInfoProto.Builder builder = SCMUpdateServiceProtos.CRLInfoProto.newBuilder();
        return builder.setX509CRL(CRLCodec.getPEMEncodedString(this.getX509CRL())).setCreationTimestamp(this.getCreationTimestamp()).setCrlSequenceID(this.getCrlSequenceID()).build();
    }

    public X509CRL getX509CRL() {
        return this.x509CRL;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public long getCrlSequenceID() {
        return this.crlSequenceID;
    }

    public boolean shouldRevokeNow() {
        return this.revocationTime.isBefore(Instant.now());
    }

    public Instant getRevocationTime() {
        return this.revocationTime;
    }

    @Override
    public int compareTo(@NotNull CRLInfo o) {
        return this.compare(this, o);
    }

    @Override
    public int compare(CRLInfo o1, CRLInfo o2) {
        return Long.compare(o1.getCreationTimestamp(), o2.getCreationTimestamp());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CRLInfo that = (CRLInfo)o;
        return this.crlSequenceID == that.crlSequenceID && this.getX509CRL().equals(that.x509CRL) && this.creationTimestamp == that.creationTimestamp;
    }

    public int hashCode() {
        return Objects.hash(this.getX509CRL(), this.getCreationTimestamp());
    }

    public String toString() {
        return "CRLInfo{crlSequenceID=" + this.crlSequenceID + ", x509CRL=" + this.x509CRL.toString() + ", creationTimestamp=" + this.creationTimestamp + '}';
    }

    public static class Builder {
        private X509CRL x509CRL;
        private long creationTimestamp;
        private long crlSequenceID;

        public Builder setX509CRL(X509CRL x509CRL) {
            this.x509CRL = x509CRL;
            return this;
        }

        public Builder setCreationTimestamp(long creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            return this;
        }

        public Builder setCrlSequenceID(long crlSequenceID) {
            this.crlSequenceID = crlSequenceID;
            return this;
        }

        public CRLInfo build() {
            return new CRLInfo(this.x509CRL, this.creationTimestamp, this.crlSequenceID);
        }
    }
}

