/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.client;

import java.io.IOException;
import java.io.InputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hdds.security.OzoneSecurityException;
import org.apache.hadoop.hdds.security.x509.certificates.utils.CertificateSignRequest;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.hadoop.hdds.security.x509.exceptions.CertificateException;

public interface CertificateClient {
    public PrivateKey getPrivateKey();

    public PublicKey getPublicKey();

    public X509Certificate getCertificate(String var1) throws CertificateException;

    public X509Certificate getCertificate();

    public X509Certificate getCACertificate();

    public boolean verifyCertificate(X509Certificate var1);

    public byte[] signDataStream(InputStream var1) throws CertificateException;

    public byte[] signData(byte[] var1) throws CertificateException;

    public boolean verifySignature(InputStream var1, byte[] var2, X509Certificate var3) throws CertificateException;

    public boolean verifySignature(byte[] var1, byte[] var2, X509Certificate var3) throws CertificateException;

    public CertificateSignRequest.Builder getCSRBuilder() throws CertificateException;

    public X509Certificate queryCertificate(String var1);

    public void storeCertificate(String var1, boolean var2) throws CertificateException;

    public void storeCertificate(String var1, boolean var2, boolean var3) throws CertificateException;

    public void storeTrustChain(CertStore var1) throws CertificateException;

    public void storeTrustChain(List<X509Certificate> var1) throws CertificateException;

    public InitResponse init() throws CertificateException;

    public String getSignatureAlgorithm();

    public String getSecurityProvider();

    public String getComponentName();

    public X509Certificate getRootCACertificate();

    public void storeRootCACertificate(String var1, boolean var2) throws CertificateException;

    public List<String> getCAList();

    public List<String> listCA() throws IOException;

    public List<String> updateCAList() throws IOException;

    public List<CRLInfo> getCrls(List<Long> var1) throws IOException;

    public long getLatestCrlId() throws IOException;

    default public void assertValidKeysAndCertificate() throws OzoneSecurityException {
        try {
            Objects.requireNonNull(this.getPublicKey());
            Objects.requireNonNull(this.getPrivateKey());
            Objects.requireNonNull(this.getCertificate());
        }
        catch (Exception e) {
            throw new OzoneSecurityException("Error reading keypair & certificate", e, OzoneSecurityException.ResultCodes.OM_PUBLIC_PRIVATE_KEY_FILE_NOT_EXIST);
        }
    }

    public long getLocalCrlId();

    public void setLocalCrlId(long var1);

    public boolean processCrl(CRLInfo var1);

    public static enum InitResponse {
        SUCCESS,
        FAILURE,
        GETCERT,
        RECOVER;

    }
}

