/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles;

import java.util.Map;
import java.util.function.BiFunction;
import org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles.DefaultProfile;
import org.apache.hadoop.hdds.security.x509.certificate.authority.PKIProfiles.PKIProfile;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.KeyUsage;

public class DefaultCAProfile
extends DefaultProfile {
    static final BiFunction<Extension, PKIProfile, Boolean> VALIDATE_BASIC_CONSTRAINTS = DefaultCAProfile::validateBasicExtensions;
    static final BiFunction<Extension, PKIProfile, Boolean> VALIDATE_CRL_NUMBER = (e, b) -> Boolean.TRUE;
    static final BiFunction<Extension, PKIProfile, Boolean> VALIDATE_REASON_CODE = (e, b) -> Boolean.TRUE;
    static final BiFunction<Extension, PKIProfile, Boolean> VALIDATE_DELTA_CRL_INDICATOR = (e, b) -> Boolean.TRUE;
    static final BiFunction<Extension, PKIProfile, Boolean> VALIDATE_NAME_CONSTRAINTS = (e, b) -> Boolean.TRUE;
    static final BiFunction<Extension, PKIProfile, Boolean> VALIDATE_CRL_DISTRIBUTION_POINTS = (e, b) -> Boolean.TRUE;

    private static boolean validateBasicExtensions(Extension ext, PKIProfile pkiProfile) {
        BasicConstraints constraints = BasicConstraints.getInstance((Object)ext.getParsedValue());
        return constraints.isCA() && pkiProfile.isCA();
    }

    @Override
    public boolean isCA() {
        return true;
    }

    @Override
    public Map<ASN1ObjectIdentifier, BiFunction<Extension, PKIProfile, Boolean>> getExtensionsMap() {
        EXTENSIONS_MAP.putIfAbsent(Extension.basicConstraints, VALIDATE_BASIC_CONSTRAINTS);
        return EXTENSIONS_MAP;
    }

    @Override
    public KeyUsage getKeyUsage() {
        return new KeyUsage(190);
    }
}

