/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.authority;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.metadata.Replicate;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.security.x509.certificate.CertInfo;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CRLApprover;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.hadoop.hdds.security.x509.crl.CRLStatus;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.cert.X509CertificateHolder;

public interface CertificateStore {
    @Replicate
    public void storeValidCertificate(BigInteger var1, X509Certificate var2, HddsProtos.NodeType var3) throws IOException;

    public void storeValidScmCertificate(BigInteger var1, X509Certificate var2) throws IOException;

    public void checkValidCertID(BigInteger var1) throws IOException;

    @Replicate
    public Optional<Long> revokeCertificates(List<BigInteger> var1, X509CertificateHolder var2, CRLReason var3, Date var4, CRLApprover var5) throws IOException;

    public void removeExpiredCertificate(BigInteger var1) throws IOException;

    public X509Certificate getCertificateByID(BigInteger var1, CertType var2) throws IOException;

    public CertInfo getRevokedCertificateInfoByID(BigInteger var1) throws IOException;

    public List<X509Certificate> listCertificate(HddsProtos.NodeType var1, BigInteger var2, int var3, CertType var4) throws IOException;

    public void reinitialize(SCMMetadataStore var1);

    public List<CRLInfo> getCrls(List<Long> var1) throws IOException;

    public long getLatestCrlId();

    public CRLStatus getCRLStatusForDN(UUID var1);

    public void setCRLStatusForDN(UUID var1, CRLStatus var2);

    public static enum CertType {
        VALID_CERTS,
        REVOKED_CERTS;

    }
}

