/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate.authority;

import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Future;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.scm.metadata.SCMMetadataStore;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.authority.CertificateApprover;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.bouncycastle.asn1.x509.CRLReason;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;

public interface CertificateServer {
    public void init(SecurityConfig var1, CAType var2) throws IOException;

    public X509CertificateHolder getCACertificate() throws CertificateException, IOException;

    public X509Certificate getCertificate(String var1) throws CertificateException, IOException;

    public Future<X509CertificateHolder> requestCertificate(PKCS10CertificationRequest var1, CertificateApprover.ApprovalType var2, HddsProtos.NodeType var3) throws SCMSecurityException;

    public Future<X509CertificateHolder> requestCertificate(String var1, CertificateApprover.ApprovalType var2, HddsProtos.NodeType var3) throws IOException;

    public Future<Optional<Long>> revokeCertificates(List<BigInteger> var1, CRLReason var2, Date var3);

    public List<X509Certificate> listCertificate(HddsProtos.NodeType var1, long var2, int var4, boolean var5) throws IOException;

    public void reinitialize(SCMMetadataStore var1);

    public List<CRLInfo> getCrls(List<Long> var1) throws IOException;

    public long getLatestCrlId();

    public static enum CAType {
        SELF_SIGNED_CA,
        INTERMEDIARY_CA;

    }
}

