/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.x509.certificate;

import java.io.IOException;
import java.io.Serializable;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.Objects;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.x509.certificate.utils.CertificateCodec;
import org.jetbrains.annotations.NotNull;

public class CertInfo
implements Comparator<CertInfo>,
Comparable<CertInfo>,
Serializable {
    private X509Certificate x509Certificate;
    private long timestamp;

    private CertInfo(X509Certificate x509Certificate, long timestamp) {
        this.x509Certificate = x509Certificate;
        this.timestamp = timestamp;
    }

    public CertInfo() {
    }

    public static CertInfo fromProtobuf(HddsProtos.CertInfoProto info) throws IOException, CertificateException {
        Builder builder = new Builder();
        return builder.setX509Certificate(CertificateCodec.getX509Certificate((String)info.getX509Certificate())).setTimestamp(info.getTimestamp()).build();
    }

    public HddsProtos.CertInfoProto getProtobuf() throws SCMSecurityException {
        HddsProtos.CertInfoProto.Builder builder = HddsProtos.CertInfoProto.newBuilder();
        return builder.setX509Certificate(CertificateCodec.getPEMEncodedString((X509Certificate)this.getX509Certificate())).setTimestamp(this.getTimestamp()).build();
    }

    public X509Certificate getX509Certificate() {
        return this.x509Certificate;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public int compareTo(@NotNull CertInfo o) {
        return this.compare(this, o);
    }

    @Override
    public int compare(CertInfo o1, CertInfo o2) {
        return Long.compare(o1.getTimestamp(), o2.getTimestamp());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CertInfo that = (CertInfo)o;
        return this.getX509Certificate().equals(that.getX509Certificate()) && this.getTimestamp() == that.getTimestamp();
    }

    public int hashCode() {
        return Objects.hash(this.getX509Certificate(), this.getTimestamp());
    }

    public String toString() {
        return "CertInfo{x509Certificate=" + this.x509Certificate.toString() + ", timestamp=" + this.timestamp + '}';
    }

    public static class Builder {
        private X509Certificate x509Certificate;
        private long timestamp;

        public Builder setX509Certificate(X509Certificate x509Certificate) {
            this.x509Certificate = x509Certificate;
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public CertInfo build() {
            return new CertInfo(this.x509Certificate, this.timestamp);
        }
    }
}

