/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Objects;
import org.apache.hadoop.hdds.protocol.datanode.proto.ContainerProtos;
import org.apache.hadoop.hdds.security.exception.SCMSecurityException;
import org.apache.hadoop.hdds.security.token.BlockTokenException;
import org.apache.hadoop.hdds.security.token.ShortLivedTokenIdentifier;
import org.apache.hadoop.hdds.security.token.TokenVerifier;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.hdds.security.x509.certificate.client.CertificateClient;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public abstract class ShortLivedTokenVerifier<T extends ShortLivedTokenIdentifier>
implements TokenVerifier {
    private final CertificateClient caClient;
    private final SecurityConfig conf;

    protected ShortLivedTokenVerifier(SecurityConfig conf, CertificateClient caClient) {
        this.conf = conf;
        this.caClient = caClient;
    }

    protected abstract boolean isTokenRequired(ContainerProtos.Type var1);

    protected abstract T createTokenIdentifier();

    protected abstract Object getService(ContainerProtos.ContainerCommandRequestProtoOrBuilder var1);

    protected void verify(T tokenId, ContainerProtos.ContainerCommandRequestProtoOrBuilder cmd) throws SCMSecurityException {
    }

    @Override
    public void verify(String user, Token<?> token, ContainerProtos.ContainerCommandRequestProtoOrBuilder cmd) throws SCMSecurityException {
        if (!this.isTokenRequired(cmd.getCmdType())) {
            return;
        }
        if (this.caClient == null) {
            throw new SCMSecurityException("Certificate client not available to validate token");
        }
        T tokenId = this.createTokenIdentifier();
        try {
            tokenId.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(token.getIdentifier())));
        }
        catch (IOException ex) {
            throw new BlockTokenException("Failed to decode token : " + token);
        }
        UserGroupInformation tokenUser = tokenId.getUser();
        X509Certificate signerCert = this.caClient.getCertificate(tokenId.getCertSerialId());
        if (signerCert == null) {
            throw new BlockTokenException("Can't find signer certificate (CertSerialId: " + tokenId.getCertSerialId() + ") of the token for user: " + tokenUser);
        }
        try {
            signerCert.checkValidity();
        }
        catch (CertificateExpiredException exExp) {
            throw new BlockTokenException("Token can't be verified due to expired certificate " + tokenId.getCertSerialId());
        }
        catch (CertificateNotYetValidException exNyv) {
            throw new BlockTokenException("Token can't be verified due to not yet valid certificate " + tokenId.getCertSerialId());
        }
        if (!this.caClient.verifySignature(tokenId.getBytes(), token.getPassword(), signerCert)) {
            throw new BlockTokenException("Invalid token for user: " + tokenUser);
        }
        if (tokenId.isExpired(Instant.now())) {
            throw new BlockTokenException("Expired token for user: " + tokenUser);
        }
        String service = String.valueOf(this.getService(cmd));
        if (!Objects.equals(service, tokenId.getService())) {
            throw new BlockTokenException("ID mismatch. Token for ID: " + tokenId.getService() + " can't be used to access: " + service + " by user: " + tokenUser);
        }
        this.verify(tokenId, cmd);
    }

    protected SecurityConfig getConf() {
        return this.conf;
    }
}

