/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.security.token;

import java.time.Instant;
import org.apache.hadoop.hdds.annotation.InterfaceAudience;
import org.apache.hadoop.hdds.annotation.InterfaceStability;
import org.apache.hadoop.hdds.security.OzoneSecretManager;
import org.apache.hadoop.hdds.security.token.ShortLivedTokenIdentifier;
import org.apache.hadoop.hdds.security.x509.SecurityConfig;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.slf4j.Logger;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class ShortLivedTokenSecretManager<T extends ShortLivedTokenIdentifier>
extends OzoneSecretManager<T> {
    private static final Text SERVICE = new Text("HDDS_SERVICE");
    private final String certSerialId;

    protected ShortLivedTokenSecretManager(SecurityConfig conf, long tokenLifetime, String certSerialId, Logger logger) {
        super(conf, tokenLifetime, tokenLifetime, SERVICE, logger);
        this.certSerialId = certSerialId;
    }

    public T createIdentifier() {
        throw new SecurityException("Short-lived token requires additional information (owner, etc.).");
    }

    @Override
    public long renewToken(Token<T> token, String renewer) {
        throw new UnsupportedOperationException("Renew token operation is not supported for short-lived tokens.");
    }

    @Override
    public T cancelToken(Token<T> token, String canceller) {
        throw new UnsupportedOperationException("Cancel token operation is not supported for short-lived tokens.");
    }

    public byte[] retrievePassword(T identifier) throws SecretManager.InvalidToken {
        this.validateToken(identifier);
        return this.createPassword(identifier);
    }

    protected boolean validateToken(T identifier) throws SecretManager.InvalidToken {
        Instant now = Instant.now();
        if (identifier.isExpired(now)) {
            throw new SecretManager.InvalidToken("token " + this.formatTokenId(identifier) + " is expired, current time: " + now + " expiry time: " + identifier.getExpiry());
        }
        return true;
    }

    protected Instant getTokenExpiryTime() {
        return Instant.now().plusMillis(this.getTokenMaxLifetime());
    }

    protected String getCertSerialId() {
        return this.certSerialId;
    }

    public Token<T> generateToken(T tokenIdentifier) {
        return new Token(tokenIdentifier.getBytes(), this.createPassword(tokenIdentifier), tokenIdentifier.getKind(), new Text(tokenIdentifier.getService()));
    }
}

