/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.update.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hdds.conf.ConfigurationSource;
import org.apache.hadoop.hdds.protocol.scm.proto.SCMUpdateServiceGrpc;
import org.apache.hadoop.hdds.protocol.scm.proto.SCMUpdateServiceProtos;
import org.apache.hadoop.hdds.scm.update.client.CRLClientUpdateHandler;
import org.apache.hadoop.hdds.scm.update.client.ClientCRLStore;
import org.apache.hadoop.hdds.scm.update.client.SCMUpdateClientConfiguration;
import org.apache.hadoop.hdds.scm.update.client.UpdateServiceConfig;
import org.apache.hadoop.hdds.scm.update.server.SCMUpdateClientInfo;
import org.apache.ratis.thirdparty.io.grpc.Channel;
import org.apache.ratis.thirdparty.io.grpc.Deadline;
import org.apache.ratis.thirdparty.io.grpc.ManagedChannel;
import org.apache.ratis.thirdparty.io.grpc.netty.NettyChannelBuilder;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCMUpdateServiceGrpcClient {
    private static final Logger LOG = LoggerFactory.getLogger(SCMUpdateServiceGrpcClient.class);
    private static final String CLIENT_NAME = "SCMUpdateServiceGrpcClient";
    private ManagedChannel channel;
    private SCMUpdateServiceGrpc.SCMUpdateServiceStub updateClient;
    private SCMUpdateServiceGrpc.SCMUpdateServiceBlockingStub subscribeClient;
    private final AtomicBoolean isRunning = new AtomicBoolean(false);
    private UUID clientId = null;
    private StreamObserver<SCMUpdateServiceProtos.UpdateRequest> requestObserver;
    private CRLClientUpdateHandler handler;
    private long crlCheckInterval;
    private final String host;
    private final int port;
    private final ClientCRLStore clientCRLStore;
    private AtomicLong updateCount;
    private AtomicLong errorCount;
    private AtomicLong pendingCrlRemoveCount;

    public SCMUpdateServiceGrpcClient(String host, ConfigurationSource conf, ClientCRLStore clientCRLStore) {
        Preconditions.checkNotNull((Object)conf);
        this.host = host;
        this.port = ((UpdateServiceConfig)conf.getObject(UpdateServiceConfig.class)).getPort();
        this.crlCheckInterval = ((SCMUpdateClientConfiguration)conf.getObject(SCMUpdateClientConfiguration.class)).getClientCrlCheckInterval();
        this.clientCRLStore = clientCRLStore;
        this.createChannel();
        this.updateCount = new AtomicLong();
        this.errorCount = new AtomicLong();
        this.pendingCrlRemoveCount = new AtomicLong();
    }

    public void start() {
        if (!this.isRunning.compareAndSet(false, true)) {
            LOG.info("Ignore. already started.");
            return;
        }
        LOG.info("{}: starting...", (Object)CLIENT_NAME);
        if (this.channel == null) {
            this.createChannel();
        }
        this.clientId = this.subScribeClient();
        assert (this.clientId != null);
        this.handler = new CRLClientUpdateHandler(this.clientId, this.updateClient, this, this.crlCheckInterval);
        this.handler.start();
        LOG.info("{}: started.", (Object)CLIENT_NAME);
    }

    public void incrUpdateCount() {
        this.updateCount.incrementAndGet();
    }

    public void incrErrorCount() {
        this.errorCount.incrementAndGet();
    }

    public void incrPendingCrlRemoveCount() {
        this.pendingCrlRemoveCount.incrementAndGet();
    }

    @VisibleForTesting
    public long getUpdateCount() {
        return this.updateCount.get();
    }

    @VisibleForTesting
    public long getErrorCount() {
        return this.errorCount.get();
    }

    @VisibleForTesting
    public long getPendingCrlRemoveCount() {
        return this.pendingCrlRemoveCount.get();
    }

    public ClientCRLStore getClientCRLStore() {
        return this.clientCRLStore;
    }

    public AtomicBoolean getIsRunning() {
        return this.isRunning;
    }

    public void stop(boolean shutdown) {
        LOG.info("{}: stopping...", (Object)CLIENT_NAME);
        if (this.isRunning.get()) {
            if (this.requestObserver != null) {
                this.requestObserver.onCompleted();
                this.requestObserver = null;
            }
            if (this.handler != null) {
                this.handler.stop();
                this.handler = null;
            }
            if (shutdown) {
                this.shutdownChannel();
            }
            this.isRunning.set(false);
        }
        LOG.info("{}: stopped.", (Object)CLIENT_NAME);
    }

    public void restart() {
        this.resetClient();
        this.stop(false);
        this.start();
    }

    public void createChannel() {
        NettyChannelBuilder channelBuilder = NettyChannelBuilder.forAddress((String)this.host, (int)this.port).usePlaintext().maxInboundMessageSize(0x2000000);
        this.channel = channelBuilder.build();
        this.updateClient = SCMUpdateServiceGrpc.newStub((Channel)this.channel);
        this.subscribeClient = SCMUpdateServiceGrpc.newBlockingStub((Channel)this.channel);
    }

    public void shutdownChannel() {
        if (this.channel == null) {
            return;
        }
        this.channel.shutdown();
        try {
            this.channel.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("Failed to shutdown {} channel", (Object)CLIENT_NAME, (Object)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.channel.shutdownNow();
            this.channel = null;
        }
    }

    private UUID subScribeClient() {
        SCMUpdateServiceProtos.SubscribeRequest subReq = SCMUpdateServiceProtos.SubscribeRequest.newBuilder().build();
        SCMUpdateServiceProtos.SubscribeResponse subResp = ((SCMUpdateServiceGrpc.SCMUpdateServiceBlockingStub)this.subscribeClient.withWaitForReady()).subscribe(subReq);
        return SCMUpdateClientInfo.fromClientIdProto(subResp.getClientId());
    }

    private void unSubscribeClient() {
        if (this.clientId != null) {
            SCMUpdateServiceProtos.UnsubscribeRequest unsubReq = SCMUpdateServiceProtos.UnsubscribeRequest.newBuilder().setClientId(SCMUpdateClientInfo.toClientIdProto(this.clientId)).build();
            ((SCMUpdateServiceGrpc.SCMUpdateServiceBlockingStub)((SCMUpdateServiceGrpc.SCMUpdateServiceBlockingStub)this.subscribeClient.withWaitForReady()).withDeadline(Deadline.after((long)5L, (TimeUnit)TimeUnit.MILLISECONDS))).unsubscribe(unsubReq);
        }
    }

    private void resetClient() {
        if (this.channel == null) {
            return;
        }
        this.channel.resetConnectBackoff();
    }
}

