/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.update.client;

import java.io.IOException;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.scm.update.client.CRLStore;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;

public class ClientCRLStore
implements CRLStore {
    private PriorityQueue<CRLInfo> pendingCrls;
    private List<Long> revokedCerts = new ArrayList<Long>();
    private long localCrlId = 0L;

    public ClientCRLStore() {
        this.pendingCrls = new PriorityQueue<CRLInfo>(new Comparator<CRLInfo>(){

            @Override
            public int compare(CRLInfo o1, CRLInfo o2) {
                return o1.getRevocationTime().compareTo(o2.getRevocationTime());
            }
        });
    }

    @Override
    public long getLatestCrlId() {
        return this.localCrlId;
    }

    public void setLocalCrlId(long crlId) {
        this.localCrlId = crlId;
    }

    @Override
    public CRLInfo getCRL(long crlId) throws IOException {
        return null;
    }

    public void onRevokeCerts(CRLInfo crl) {
        if (crl.shouldRevokeNow()) {
            this.revokedCerts.addAll(this.getRevokedCertIds(crl.getX509CRL()));
        } else {
            this.pendingCrls.add(crl);
        }
        this.localCrlId = crl.getCrlSequenceID();
    }

    public List<Long> getRevokedCertIds(X509CRL crl) {
        return Collections.unmodifiableList(crl.getRevokedCertificates().stream().map(cert -> cert.getSerialNumber().longValue()).collect(Collectors.toList()));
    }

    public CRLInfo getNextPendingCrl() {
        return this.pendingCrls.peek();
    }

    public void removePendingCrl(CRLInfo crl) {
        this.pendingCrls.remove(crl);
        this.revokedCerts.addAll(this.getRevokedCertIds(crl.getX509CRL()));
    }

    public List<Long> getPendingCrlIds() {
        return new ArrayList<CRLInfo>(this.pendingCrls).stream().map(crl -> crl.getCrlSequenceID()).collect(Collectors.toList());
    }
}

