/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdds.scm.update.client;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hdds.protocol.scm.proto.SCMUpdateServiceGrpc;
import org.apache.hadoop.hdds.protocol.scm.proto.SCMUpdateServiceProtos;
import org.apache.hadoop.hdds.scm.update.client.ClientCRLStore;
import org.apache.hadoop.hdds.scm.update.client.ClientUpdateHandler;
import org.apache.hadoop.hdds.scm.update.client.SCMUpdateServiceGrpcClient;
import org.apache.hadoop.hdds.scm.update.server.SCMUpdateClientInfo;
import org.apache.hadoop.hdds.security.x509.crl.CRLInfo;
import org.apache.ratis.thirdparty.io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLClientUpdateHandler
implements ClientUpdateHandler {
    private static final Logger LOG = LoggerFactory.getLogger(CRLClientUpdateHandler.class);
    private static final String NAME = "CRLClientUpdateHandler";
    private final SCMUpdateServiceGrpc.SCMUpdateServiceStub updateStub;
    private final ClientCRLStore clientStore;
    private StreamObserver<SCMUpdateServiceProtos.UpdateRequest> requestObserver;
    private UUID clientUuid;
    private SCMUpdateServiceProtos.ClientId clientIdProto;
    private ScheduledExecutorService executorService;
    private final SCMUpdateServiceGrpcClient serviceGrpcClient;
    private long crlCheckInterval;

    CRLClientUpdateHandler(UUID clientId, SCMUpdateServiceGrpc.SCMUpdateServiceStub updateStub, SCMUpdateServiceGrpcClient serviceGrpcClient, long crlCheckInterval) {
        this.clientUuid = clientId;
        this.updateStub = updateStub;
        this.serviceGrpcClient = serviceGrpcClient;
        this.clientStore = serviceGrpcClient.getClientCRLStore();
        this.crlCheckInterval = crlCheckInterval;
        LOG.info("Pending CRL check interval : {}s", (Object)(crlCheckInterval / 1000L));
        this.executorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CRLUpdateHandler Thread - %d").build());
    }

    public static Logger getLog() {
        return LOG;
    }

    @Override
    public void handleServerUpdate(SCMUpdateServiceProtos.UpdateResponse updateResponse) {
        CRLInfo crl;
        SCMUpdateServiceProtos.CRLInfoProto crlInfo = updateResponse.getCrlUpdateResponse().getCrlInfo();
        long receivedCrlId = crlInfo.getCrlSequenceID();
        long localCrlId = this.clientStore.getLatestCrlId();
        LOG.debug("## Client: clientId {} clientCrlId {} receivedCrlId {}", new Object[]{this.clientUuid, localCrlId, receivedCrlId});
        if (localCrlId == receivedCrlId) {
            return;
        }
        if (localCrlId > receivedCrlId) {
            LOG.warn("Received stale crlId {} lower than client crlId {}", (Object)receivedCrlId, (Object)localCrlId);
            this.sendClientUpdate();
            return;
        }
        try {
            crl = CRLInfo.fromCRLProto3(crlInfo);
        }
        catch (Exception e) {
            LOG.error("Can't parse server CRL update, skip...", (Throwable)e);
            return;
        }
        this.clientStore.onRevokeCerts(crl);
        this.sendClientUpdate();
    }

    public void start() {
        SCMUpdateServiceProtos.UpdateRequest updateReq = this.getUpdateRequest();
        this.requestObserver = ((SCMUpdateServiceGrpc.SCMUpdateServiceStub)this.updateStub.withWaitForReady()).updateStatus((StreamObserver)new StreamObserver<SCMUpdateServiceProtos.UpdateResponse>(){

            public void onNext(SCMUpdateServiceProtos.UpdateResponse updateResponse) {
                LOG.debug("Receive server response: {}", (Object)updateResponse);
                CRLClientUpdateHandler.this.serviceGrpcClient.incrUpdateCount();
                CRLClientUpdateHandler.this.handleServerUpdate(updateResponse);
            }

            public void onError(Throwable throwable) {
                LOG.debug("Receive server error ", throwable);
                CRLClientUpdateHandler.this.serviceGrpcClient.incrErrorCount();
                if (CRLClientUpdateHandler.this.serviceGrpcClient.getIsRunning().get()) {
                    LOG.warn("Restart client on server error: ", throwable);
                    CRLClientUpdateHandler.this.serviceGrpcClient.restart();
                }
            }

            public void onCompleted() {
                LOG.debug("Receive server completed");
            }
        });
        this.requestObserver.onNext((Object)updateReq);
        this.startPendingCrlChecker();
    }

    public void stop() {
        this.stopPendingCrlCheck();
    }

    private void stopPendingCrlCheck() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOG.error("InterruptedException while waiting for executor service to shutdown", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void startPendingCrlChecker() {
        this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                CRLInfo crl = null;
                while ((crl = CRLClientUpdateHandler.this.clientStore.getNextPendingCrl()) != null && crl.shouldRevokeNow()) {
                    CRLClientUpdateHandler.this.serviceGrpcClient.incrPendingCrlRemoveCount();
                    LOG.info("Time to process crlId {}", (Object)crl.getCrlSequenceID());
                    CRLClientUpdateHandler.this.clientStore.removePendingCrl(crl);
                    CRLClientUpdateHandler.this.sendClientUpdate();
                }
            }
        }, 0L, this.crlCheckInterval, TimeUnit.MILLISECONDS);
    }

    private void sendClientUpdate() {
        this.requestObserver.onNext((Object)this.getUpdateRequest());
    }

    private SCMUpdateServiceProtos.UpdateRequest getUpdateRequest() {
        return SCMUpdateServiceProtos.UpdateRequest.newBuilder().setUpdateType(SCMUpdateServiceProtos.Type.CRLUpdate).setClientId(SCMUpdateClientInfo.toClientIdProto(this.clientUuid)).setCrlUpdateRequest(this.getCrlUpdateRequest()).build();
    }

    private SCMUpdateServiceProtos.CRLUpdateRequest getCrlUpdateRequest() {
        List<Long> pendingCrlIds = this.clientStore.getPendingCrlIds();
        return SCMUpdateServiceProtos.CRLUpdateRequest.newBuilder().setReceivedCrlId(this.clientStore.getLatestCrlId()).addAllPendingCrlIds(pendingCrlIds).build();
    }
}

